/*---------------------------------------------------------
   CHORDS.C -- Displays the pattern known as chords of a
	       circle in the window.
	       (c) 1991 by Carl C. Rollo
  --------------------------------------------------------*/

#include <windows.h>
#include <math.h>
#include <string.h>
#include "chords.h"

#define ARCS 15

/* Globals: */
char szAppName[] = "Chords";
COLORREF colors [8] =
  { BLACK, RED, GREEN, BLUE, CYAN, MAGENTA, YELLOW, WHITE };

char * color_names[8] =
  { "Black", "Red", "Green", "Blue", "Cyan", "Magenta", "Yellow", "White" };

/* Prototypes: */
long FAR PASCAL WndProc (HWND, WORD, WORD, LONG);
BOOL FAR PASCAL AboutDlgProc (HWND, WORD, WORD, LONG);
void DrawPattern (HDC, short, short);

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
		    LPSTR lpszCmdParam, int nCmdShow)
  {

   HWND        hwnd;
   MSG         msg;
   WNDCLASS    wndclass;

   if (!hPrevInstance)
    {
     wndclass.style         = CS_HREDRAW | CS_VREDRAW;
     wndclass.lpfnWndProc   = WndProc;
     wndclass.cbClsExtra    = 0;
     wndclass.cbWndExtra    = 0;
     wndclass.hInstance     = hInstance;
     wndclass.hIcon         = LoadIcon(hInstance, szAppName);
     wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
     wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
     wndclass.lpszMenuName  = szAppName;
     wndclass.lpszClassName = szAppName;

     RegisterClass (&wndclass);
    }

   hwnd = CreateWindow(
    szAppName,               /* window class name       */
    "Chords of a Circle",    /* widow caption           */
    WS_OVERLAPPEDWINDOW,     /* window style            */
    CW_USEDEFAULT,           /* initial x position      */
    CW_USEDEFAULT,           /* initial y position      */
    CW_USEDEFAULT,           /* initial x size          */
    CW_USEDEFAULT,           /* initial y size          */
    NULL,                    /* parent window handle    */
    NULL,                    /* window menu handle      */
    hInstance,               /* program instance handle */
    NULL);                   /* creation parameters     */

   ShowWindow (hwnd, nCmdShow);
   UpdateWindow (hwnd);

   while (GetMessage(&msg, NULL, 0, 0))
    {
     TranslateMessage (&msg);
     DispatchMessage (&msg);
    }
   return (msg.wParam);
  }

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
 {
  HDC hdc;
  PAINTSTRUCT ps;
  RECT rect;
  HMENU hMenu;
  static HBRUSH hBrushes[8], hCurrentPen, hOldPen, hPens[8];
  static FARPROC lpfnAboutDlgProc;
  static HANDLE hInst;
  static WORD fore_color = IDM_BLACK, back_color = IDM_BACK_WHITE;
  static short cxClient, cyClient;
  short i, xPage, yPage;

  switch (message)
   {
    case WM_CREATE :
     hInst = ((LPCREATESTRUCT) lParam)->hInstance;
     lpfnAboutDlgProc = MakeProcInstance (AboutDlgProc, hInst);

     for (i = 0; i < 8; i++)
      {
       hBrushes[i] = CreateSolidBrush(colors[i]);
       hPens[i] = CreatePen (PS_SOLID, 1, colors[i]);
      }
     return (0);

    case WM_SIZE :
     cxClient = LOWORD (lParam);
     cyClient = HIWORD (lParam);
     return (0);

    case WM_COMMAND :
     hMenu = GetMenu (hwnd);
     switch (wParam)
      {
       case IDM_BLACK :
       case IDM_RED :
       case IDM_GREEN :
       case IDM_BLUE :
       case IDM_CYAN :
       case IDM_MAGENTA :
       case IDM_YELLOW :
       case IDM_WHITE :
	if (wParam != back_color - 100)
	 {
	  CheckMenuItem (hMenu, fore_color, MF_UNCHECKED);
	  fore_color = wParam;
	  CheckMenuItem (hMenu, wParam, MF_CHECKED);
	  hCurrentPen = hPens[wParam - IDM_BLACK];
	  InvalidateRect (hwnd, NULL, TRUE);
	 }
	return (0);

       case IDM_BACK_BLACK :
       case IDM_BACK_RED :
       case IDM_BACK_GREEN :
       case IDM_BACK_BLUE :
       case IDM_BACK_CYAN :
       case IDM_BACK_MAGENTA :
       case IDM_BACK_YELLOW :
       case IDM_BACK_WHITE :
	if (wParam != fore_color + 100)
	 {
	  CheckMenuItem (hMenu, back_color, MF_UNCHECKED);
	  back_color = wParam;
	  CheckMenuItem (hMenu, wParam, MF_CHECKED);
	  SetClassWord (hwnd, GCW_HBRBACKGROUND,
	   hBrushes[back_color - IDM_BACK_BLACK]);
	  InvalidateRect (hwnd, NULL, TRUE);
	 }
	return (0);

       case IDM_EXIT :
	SendMessage (hwnd, WM_CLOSE, 0, 0L);
	return (0);

       case IDM_ABOUT :
	DialogBox (hInst, "AboutBox", hwnd, lpfnAboutDlgProc);
	return (0);
      }
     break;

    case WM_PAINT :
     hdc = BeginPaint(hwnd, &ps);
     hOldPen = SelectObject (hdc, hCurrentPen);
     DrawPattern (hdc, cxClient, cyClient);
     SelectObject (hdc, hOldPen);
     EndPaint(hwnd, &ps);
     return (0);

    case WM_DESTROY :
     for (i = 0; i < 8; i++)
      {
       DeleteObject (hBrushes[i]);
       DeleteObject (hPens[i]);
      }
     PostQuitMessage (0);
     return (0);
   }
  return (DefWindowProc(hwnd, message, wParam, lParam));
 }

/* ------------------------------------------------------------------ */

BOOL FAR PASCAL AboutDlgProc (HWND hDlg, WORD message, WORD wParam,
			      LONG lParam)
 {
   switch (message)
    {
     case WM_INITDIALOG :
      return (TRUE);

     case WM_COMMAND :
      switch (wParam)
       {
	case IDOK :
	 EndDialog (hDlg, 0);
	 return (TRUE);
       }
      break;
    }
   return (FALSE);
 }

/* ------------------------------------------------------------------ */

void DrawPattern (HDC hdc, short width, short ht)
 {
   /* Draws the chords of a circle pattern in the rectangle whose size is
   ** width x ht. Pattern is drawn in the device whose Device Context is
   ** hdc.
   */
   static double AngularArc = DEG_TO_RADIANS * (360/ARCS);
   double angle1, angle2;
   short xc, yc, i, j, x1, y1, x2, y2, Radius;

   if (hdc != NULL && width > 0 && ht > 0)
    {
     xc = width/2; yc = ht/2;
     Radius = min (xc, yc);

     for (i = 1; i <= ARCS; i++)
      {
       angle1 = (i-1) * AngularArc;
       x1 = Radius * cos(angle1) + xc;
       y1 = Radius * sin(angle1) + yc;

       for (j = i+1; j <= ARCS; j++)
	{
	 angle2 = (j-1) * AngularArc;
	 x2 = Radius * cos(angle2) + xc;
	 y2 = Radius * sin(angle2) + yc;
	 MoveTo (hdc, x1, y1);
	 LineTo (hdc, x2, y2);
	}
      }
    }
 }

/* ------------------------------------------------------------------ */
