/*---------------------------------------------------------
   PIEDEMO.C -- Displays a test pattern and provides
		changes of foreground and background color
		using pie menus.
		(c) 1991,1992 by Carl C. Rollo
  --------------------------------------------------------*/
#include <windows.h>
#include <math.h>
#include <string.h>
#include "piedemo.h"
#include "piemenu.h"

#define ARCS 15

/* Globals: */
char szAppName[] = "PieDemo";

COLORREF colors [8] =
  { YELLOW, RED, GREEN, BLUE, CYAN, GRAY, BLACK, WHITE };

char *color_names[8] =
  { "Yellow", "Red", "Green", "Blue", "Cyan", "Gray", "Black", "White" };

PIE_MENU colorpie, backcolorpie;
short    menuwid, menuht;

/* Prototypes: */
long FAR PASCAL WndProc (HWND, WORD, WORD, LONG);
BOOL FAR PASCAL AboutDlgProc (HWND, WORD, WORD, LONG);
void DrawPattern (HDC, short, short);

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
		    LPSTR lpszCmdParam, int nCmdShow)
  {
   HWND        hwnd;
   HMENU       hMenu;
   MSG         msg;
   WNDCLASS    wndclass;
   short       i;

   if (!hPrevInstance)
    {
     wndclass.style         = CS_HREDRAW | CS_VREDRAW;
     wndclass.lpfnWndProc   = WndProc;
     wndclass.cbClsExtra    = 0;
     wndclass.cbWndExtra    = 0;
     wndclass.hInstance     = hInstance;
     wndclass.hIcon         = LoadIcon(hInstance, szAppName);
     wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
     wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
     wndclass.lpszMenuName  = szAppName;
     wndclass.lpszClassName = szAppName;
     RegisterClass (&wndclass);
    }

    /* Load the Pie Menu for the foreground and background color
    ** selections with the values we want and call CreatePieMenuIndirect
    ** to finish loading the data structure. Then append the Pie Menu to
    ** the application's menu resource menu.
    */
    colorpie.radius = 0;   /* let CreatePieMenu size the pie */
    colorpie.no_choice = -1;
    colorpie.n = 8;
    colorpie.InsideLabels = TRUE;
    colorpie.UseChecks = TRUE;
    for (i = 0; i < 8; i++)
     {
      colorpie.option[i].value = i;
      colorpie.option[i].name = color_names[i];
      colorpie.option[i].color = colors[i];
     }

   backcolorpie = colorpie;

   hwnd = CreateWindow(szAppName, "Demonstration of Pie Menus",
		       WS_OVERLAPPEDWINDOW,
		       CW_USEDEFAULT, CW_USEDEFAULT,
		       CW_USEDEFAULT, CW_USEDEFAULT,
		       NULL, NULL, hInstance, NULL);

   menuwid = 190; menuht = 190;

   if (!CreatePieMenuIndirect (&colorpie, &menuwid, &menuht))
    {
     MessageBox (hwnd,
      "Could not create data structure for Color Selection pie menu",
      szAppName, MB_OK);
     return (FALSE);
    }

   if (!CreatePieMenuIndirect (&backcolorpie, &menuwid, &menuht))
    {
     MessageBox (hwnd,
    "Could not create data structure for Background Color Selection pie menu",
      szAppName, MB_OK);
     return (FALSE);
    }

   hMenu = GetMenu (hwnd);
   hMenu = GetSubMenu (hMenu, 0);
   AppendMenu (GetSubMenu(hMenu,0),
	       MF_OWNERDRAW, IDM_FORECOLOR,
	       (LPSTR) (PIE_MENU far *) &colorpie);

   AppendMenu (GetSubMenu(hMenu,1),
	       MF_OWNERDRAW, IDM_BACKCOLOR,
	       (LPSTR) (PIE_MENU far *) &backcolorpie);

   DrawMenuBar (hwnd);

   ShowWindow (hwnd, nCmdShow);
   UpdateWindow (hwnd);

   while (GetMessage(&msg, NULL, 0, 0))
    {
     TranslateMessage (&msg);
     DispatchMessage (&msg);
    }
   return (msg.wParam);
  }

/* ------------------------------------------------------------------ */

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
 {
  HDC hdc;
  PAINTSTRUCT ps;
  RECT rect;
  HMENU hMenu;
  static HBRUSH hBrushes[8], hCurrentPen, hOldPen, hPens[8];
  static FARPROC lpfnAboutDlgProc;
  LPMEASUREITEMSTRUCT lpmeas;
  LPDRAWITEMSTRUCT lpdraw;
  static LPPIEMENUSTRUCT p;
  static LPVIEWWINDATA vwd;
  static HANDLE hInst;
  static WORD fore_color = 6, back_color = 7;
  static short cxClient, cyClient, color_sel, menuextra;
  short i, value_from_menu;

  switch (message)
   {
    case WM_CREATE :
     menuextra = GetSystemMetrics (SM_CYMENU);

     hInst = ((LPCREATESTRUCT) lParam)->hInstance;
     lpfnAboutDlgProc = MakeProcInstance (AboutDlgProc, hInst);

     for (i = 0; i < 8; i++)
      {
       hBrushes[i] = CreateSolidBrush(colors[i]);
       hPens[i] = CreatePen (PS_SOLID, 1, colors[i]);
      }
     return (0);

    case WM_MEASUREITEM :
     lpmeas = (LPMEASUREITEMSTRUCT) lParam;
     if ( lpmeas->CtlType == ODT_MENU )
       if ( (lpmeas->itemID == IDM_FORECOLOR) ||
	    (lpmeas->itemID == IDM_BACKCOLOR) )
	{
	 lpmeas->itemWidth = menuwid;
	 lpmeas->itemHeight = menuht + menuextra;
	 return (0);
	}
     break;

    case WM_SIZE :
     cxClient = LOWORD (lParam);
     cyClient = HIWORD (lParam);
     return (0);

    case WM_COMMAND :
     switch (wParam)
      {
       case IDM_FORECOLOR :
	if ( color_sel != back_color)
	 {
	  fore_color = color_sel;
	  hCurrentPen = hPens[fore_color];
	  InvalidateRect (hwnd, NULL, TRUE);
	 }
	return (0);

       case IDM_BACKCOLOR :
	if (color_sel != fore_color)
	 {
	  back_color = color_sel;
	  SetClassWord (hwnd, GCW_HBRBACKGROUND,
	   hBrushes[back_color]);
	  InvalidateRect (hwnd, NULL, TRUE);
	 }
	return (0);

       case IDM_EXIT :
	SendMessage (hwnd, WM_CLOSE, 0, 0L);
	return (0);

       case IDM_ABOUT :
	DialogBox (hInst, "AboutBox", hwnd, lpfnAboutDlgProc);
	return (0);
      }
     break;

    case WM_DRAWITEM :
     lpdraw = (LPDRAWITEMSTRUCT) lParam;
     if ( (lpdraw->CtlType == ODT_MENU) &&
	  (lpdraw->itemID == IDM_FORECOLOR) ||
	  (lpdraw->itemID == IDM_BACKCOLOR) )
      {
       hdc = lpdraw->hDC;

       p = (LPPIEMENUSTRUCT) (lpdraw->itemData);
       rect = lpdraw->rcItem;

       SetMapMode (hdc, MM_ISOTROPIC);
       SetWindowExt (hdc,   p->radius, p->radius);
       SetViewportExt (hdc, menuwid/2, -menuht/2);
       SetViewportOrg (hdc, (rect.right - rect.left)/2,
			    (rect.bottom - rect.top)/2 + menuextra);

       if (lpdraw->itemAction & ODA_DRAWENTIRE)
	DrawPieMenu (hdc, p);
       else
	if (lpdraw->itemAction & ODA_SELECT) /* selection state has changed */
	 if ((lpdraw->itemState & ODS_SELECTED) != 0) /* menu selected */
	  vwd = GetViewportWindowParms (hdc);

       return (0);
      }
     break;

    case WM_MENUSELECT :
     if (vwd != NULL)                   /* was a Pie Menu drawn? */
      if (LOWORD(lParam) == 0xFFFF)     /* is menu closed? */
       {
	value_from_menu = PieMenuProc(vwd, p);
	/* If the menu returned a valid choice, set the
	** color selection to the new color.
	*/
	if (value_from_menu != p->no_choice)
	 color_sel = value_from_menu;

	vwd = NULL;  /* set to indicate no menu chosen (for next time) */
	return (0);
       }
     break;

    case WM_PAINT :
     hdc = BeginPaint(hwnd, &ps);
     hOldPen = SelectObject (hdc, hCurrentPen);
     DrawPattern (hdc, cxClient, cyClient);
     SelectObject (hdc, hOldPen);
     EndPaint(hwnd, &ps);
     return (0);

    case WM_DESTROY :
     for (i = 0; i < 8; i++)
      {
       DeleteObject (hBrushes[i]);
       DeleteObject (hPens[i]);
      }
     for (i = 0; i < colorpie.n; i++)
      {
       DeleteObject (colorpie.option[i].brush);
       DeleteObject (backcolorpie.option[i].brush);
      }

     PostQuitMessage (0);
     return (0);
   }
  return (DefWindowProc(hwnd, message, wParam, lParam));
 }

/* ------------------------------------------------------------------ */

BOOL FAR PASCAL AboutDlgProc (HWND hDlg, WORD message, WORD wParam,
                              LONG lParam)
 {
   switch (message)
    {
     case WM_INITDIALOG :
      return (TRUE);

     case WM_COMMAND :
      switch (wParam)
       {
	case IDOK :
	 EndDialog (hDlg, 0);
	 return (TRUE);
       }
      break;
    }
   return (FALSE);
 }

/* ------------------------------------------------------------------ */

void DrawPattern (HDC hdc, short width, short ht)
 {
   /* Draws the chords of a circle pattern in the rectangle whose size is
   ** width X ht. Pattern is drawn in the Device Context, hdc.
   */
   static double AngularArc = DEG_TO_RADIANS * (360/ARCS);
   double angle1, angle2;
   short xc, yc, i, j, x1, y1, x2, y2, Radius;

   if (hdc != NULL && width > 0 && ht > 0)
    {
     xc = width/2; yc = ht/2;
     Radius = min (xc, yc);
     for (i = 1; i <= ARCS; i++)
      {
       angle1 = (i-1) * AngularArc;
       x1 = Radius * cos(angle1) + xc;
       y1 = Radius * sin(angle1) + yc;

       for (j = i+1; j <= ARCS; j++)
	{
	 angle2 = (j-1) * AngularArc;
	 x2 = Radius * cos(angle2) + xc;
	 y2 = Radius * sin(angle2) + yc;
	 MoveTo (hdc, x1, y1);
	 LineTo (hdc, x2, y2);
	}
      }
    }
 }

/* ------------------------------------------------------------------ */
