/*---------------------------------------------------------
   PIEDEMO2.C -- Uses Pie Menus for all menu selections.
		 Same functions as the "Chords.c" program.
		 (c) 1991,1992 by Carl C. Rollo
  --------------------------------------------------------- */

#include <windows.h>
#include <math.h>
#include <string.h>
#include "piedemo2.h"
#include "piemenu.h"

#define ARCS 15

/* Globals: */
char szAppName[] = "PieDemo2";
short xcur, ycur, xDC, yDC, xlog, ylog;

COLORREF colors [8] =
  { YELLOW, RED, GREEN, BLUE, CYAN, GRAY, BLACK, WHITE };

char *color_names[8] =
  { "Yellow", "Red", "Green", "Blue", "Cyan", "Gray", "Black", "White" };

char *option_name[4] =
  { "Figure", "Backgrnd", "About...", "Exit" };

short option_codes[4] =
  { IDM_FORECOLOR, IDM_BACKCOLOR, IDM_ABOUT, IDM_EXIT };

PIE_MENU optionpie, colorpie, backcolorpie;
HMENU hForeMenu, hBackMenu;
short menuwid, menuht;

/* Prototypes: */
long FAR PASCAL WndProc (HWND, WORD, WORD, LONG);
BOOL FAR PASCAL AboutDlgProc (HWND, WORD, WORD, LONG);
void DrawPattern (HDC, short, short);

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
		    LPSTR lpszCmdParam, int nCmdShow)
  {

   HWND        hwnd;
   HMENU       hMenu;
   MSG         msg;
   WNDCLASS    wndclass;
   short       i;
   if (!hPrevInstance)
    {
     wndclass.style         = CS_HREDRAW | CS_VREDRAW;
     wndclass.lpfnWndProc   = WndProc;
     wndclass.cbClsExtra    = 0;
     wndclass.cbWndExtra    = 0;
     wndclass.hInstance     = hInstance;
     wndclass.hIcon         = LoadIcon(hInstance, szAppName);
     wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
     wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
     wndclass.lpszMenuName  = szAppName;
     wndclass.lpszClassName = szAppName;

     RegisterClass (&wndclass);
    }

    /* Load the Option Pie Menu. This will be our highest level menu. */
    optionpie.radius = 0;
    optionpie.no_choice = -1;
    optionpie.n = 4;
    optionpie.InsideLabels = TRUE;
    optionpie.UseChecks = TRUE;

    for (i = 0; i < 4; i++)
     {
      optionpie.option[i].value = option_codes[i];
      optionpie.option[i].name = option_name[i];
      optionpie.option[i].color = YELLOW;
     }

    /* Load the Pie Menu for the foreground and background color
    ** selections with the values we want and call CreatePieMenuIndirect
    ** to finish loading the data structure. Then append the Pie Menu to
    ** the application's menu resource menu.
    */
    colorpie.radius = 0;   /* let CreatePieMenu size the pie */
    colorpie.no_choice = -1;
    colorpie.n = 8;
    colorpie.InsideLabels = TRUE;
    colorpie.UseChecks = TRUE;

    for (i = 0; i < 8; i++)
     {
      colorpie.option[i].value = i;
      colorpie.option[i].name = color_names[i];
      colorpie.option[i].color = colors[i];
     }

   backcolorpie = colorpie;

   hwnd = CreateWindow(szAppName, "Demonstration of Pie Menus",
		       WS_OVERLAPPEDWINDOW,
		       CW_USEDEFAULT, CW_USEDEFAULT,
		       CW_USEDEFAULT, CW_USEDEFAULT,
		       NULL, NULL, hInstance, NULL);

   menuwid = 190; menuht = 190;
   if (!CreatePieMenuIndirect (&optionpie, &menuwid, &menuht))
    {
     MessageBox (hwnd,
      "Could not create data structure for Option pie menu",
      szAppName, MB_OK);
     return (FALSE);
    }


   if (!CreatePieMenuIndirect (&colorpie, &menuwid, &menuht))
    {
     MessageBox (hwnd,
      "Could not create data structure for Color Selection pie menu",
      szAppName, MB_OK);
     return (FALSE);
    }

   if (!CreatePieMenuIndirect (&backcolorpie, &menuwid, &menuht))
    {
     MessageBox (hwnd,
      "Could not create data structure for Background Color Selection pie menu",
      szAppName, MB_OK);
     return (FALSE);
    }

   /* Append the Owner Draw Menus to the popup menu definitions. */
   hMenu = GetMenu(hwnd);
   hMenu = GetSubMenu(hMenu, 0);
   AppendMenu (hMenu, MF_OWNERDRAW, IDM_OPTIONS,
	       (LPSTR) (LPPIEMENUSTRUCT) &optionpie);

   hMenu = LoadMenu (hInstance, "ForeMenu");
   hForeMenu = GetSubMenu (hMenu, 0);
   AppendMenu (hForeMenu,
	       MF_OWNERDRAW, IDM_FORECOLOR,
	       (LPSTR) (PIE_MENU far *) &colorpie);

   hMenu = LoadMenu (hInstance, "BackMenu");
   hBackMenu = GetSubMenu (hMenu, 0);
   AppendMenu (hBackMenu,
	       MF_OWNERDRAW, IDM_BACKCOLOR,
	       (LPSTR) (PIE_MENU far *) &backcolorpie);

   DrawMenuBar (hwnd);

   ShowWindow (hwnd, nCmdShow);
   UpdateWindow (hwnd);

   while (GetMessage(&msg, NULL, 0, 0))
    {
     TranslateMessage (&msg);
     DispatchMessage (&msg);
    }
   return (msg.wParam);
  }

/* ------------------------------------------------------------------ */

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
 {
  HDC hdc;
  PAINTSTRUCT ps;
  RECT rect;
  HMENU hMenu;
  static HBRUSH hBrushes[8], hCurrentPen, hOldPen, hPens[8];
  static FARPROC lpfnAboutDlgProc;
  LPMEASUREITEMSTRUCT lpmeas;
  LPDRAWITEMSTRUCT lpdraw;
  static LPPIEMENUSTRUCT p;
  static LPVIEWWINDATA vwd;
  static HANDLE hInst;
  static WORD fore_color = 6, back_color = 7, option_chosen;
  static short cxClient, cyClient, color_sel, menuextra, value_from_menu;
  short i;

  switch (message)
   {
    case WM_CREATE :
     menuextra = GetSystemMetrics (SM_CYMENU);

     hInst = ((LPCREATESTRUCT) lParam)->hInstance;
     lpfnAboutDlgProc = MakeProcInstance (AboutDlgProc, hInst);

     for (i = 0; i < 8; i++)
      {
       hBrushes[i] = CreateSolidBrush(colors[i]);
       hPens[i] = CreatePen (PS_SOLID, 1, colors[i]);
      }
     return (0);

    case WM_MEASUREITEM :
     lpmeas = (LPMEASUREITEMSTRUCT) lParam;
     if ( lpmeas->CtlType == ODT_MENU )
       if ( (lpmeas->itemID == IDM_FORECOLOR) ||
	    (lpmeas->itemID == IDM_BACKCOLOR) ||
	    (lpmeas->itemID == IDM_OPTIONS) )
	{
	 lpmeas->itemWidth = menuwid;
	 lpmeas->itemHeight = menuht + menuextra;
	 return (0);
	}
     break;

    case WM_SIZE :
     cxClient = LOWORD (lParam);
     cyClient = HIWORD (lParam);
     return (0);

    case WM_COMMAND :
     switch (wParam)
      {
       case IDM_OPTIONS :
	switch(value_from_menu)
	 {
	  case IDM_FORECOLOR :
	   TrackPopupMenu (hForeMenu, 0,
	    LOWORD(vwd->DCOrg) + vwd->ClientRect.right,
	    HIWORD(vwd->DCOrg) +
	    (vwd->ClientRect.bottom - vwd->ClientRect.top)/2,
	    0, hwnd, NULL);
	   break;

	  case IDM_BACKCOLOR :
	   TrackPopupMenu (hBackMenu, 0,
	    LOWORD(vwd->DCOrg) + vwd->ClientRect.right,
	    HIWORD(vwd->DCOrg) +
	    (vwd->ClientRect.bottom - vwd->ClientRect.top)/2,
	    0, hwnd, NULL);
	   break;
	 }
	return (0);

       case IDM_FORECOLOR :
	if ( color_sel != back_color)
	 {
	  fore_color = color_sel;
	  hCurrentPen = hPens[fore_color];
	  InvalidateRect (hwnd, NULL, TRUE);
	 }
	vwd = NULL;
	return (0);

       case IDM_BACKCOLOR :
	if (color_sel != fore_color)
	 {
	  back_color = color_sel;
	  SetClassWord (hwnd, GCW_HBRBACKGROUND,
	   hBrushes[back_color]);
	  InvalidateRect (hwnd, NULL, TRUE);
	 }
	vwd = NULL;
	return (0);

       case IDM_EXIT :
	SendMessage (hwnd, WM_CLOSE, 0, 0L);
	return (0);

       case IDM_ABOUT :
	DialogBox (hInst, "AboutBox", hwnd, lpfnAboutDlgProc);
	vwd = NULL;
	return (0);
      }
     break;

    case WM_DRAWITEM :
     lpdraw = (LPDRAWITEMSTRUCT) lParam;
     if ( (lpdraw->CtlType == ODT_MENU) &&
	  (lpdraw->itemID == IDM_FORECOLOR) ||
	  (lpdraw->itemID == IDM_BACKCOLOR) ||
	  (lpdraw->itemID == IDM_OPTIONS) )
      {
       hdc = lpdraw->hDC;

       p = (LPPIEMENUSTRUCT) (lpdraw->itemData);
       rect = lpdraw->rcItem;

       SetMapMode (hdc, MM_ISOTROPIC);
       SetWindowExt (hdc,   p->radius, p->radius);
       SetViewportExt (hdc, menuwid/2, -menuht/2);
       SetViewportOrg (hdc, (rect.right - rect.left)/2,
			    (rect.bottom - rect.top)/2 + menuextra);

       if (lpdraw->itemAction & ODA_DRAWENTIRE)
	DrawPieMenu (hdc, p);
       else
	if (lpdraw->itemAction & ODA_SELECT)
	 if ((lpdraw->itemState & ODS_SELECTED) != 0)
	  {
	   vwd = GetViewportWindowParms(hdc);
	   vwd->ClientRect = rect;
	   option_chosen = lpdraw->itemID;
	  }

       return (0);
      }
     break;

    case WM_MENUSELECT :
     if (vwd != NULL)      /* Pie Menu chosen */
      if (LOWORD(lParam) == 0xFFFF)     /* selection made */
       {
	/* Get the selection from the position of the mouse cursor as the
	** menu is about to close.
	*/
	value_from_menu = PieMenuProc(vwd, p);

	switch(option_chosen)
	 {
	  case IDM_OPTIONS :
	   switch (value_from_menu)
	    {
	     /* In these cases we generate our own WM_COMMAND message. */
	     case IDM_ABOUT :
	     case IDM_EXIT :
	      PostMessage (hwnd, WM_COMMAND, value_from_menu, 0L);
	      break;

	     /* If the option chosen was foreground or background color,
	     ** we let Windows send us a WM_COMMAND with the wParam value
	     ** of IDM_OPTIONS and handle the next layer of menus in the
	     ** WM_COMMAND case. */

	     default :
	      break;
	    }
	   break;

	  case IDM_FORECOLOR :
	  case IDM_BACKCOLOR :
	   if (value_from_menu != p->no_choice)
	    color_sel = value_from_menu;
	   break;
	 }

	return (0);
       }
     /* It isn't a Pie Menu or a selection has not been made */
     break;

    case WM_PAINT :
     hdc = BeginPaint(hwnd, &ps);
     hOldPen = SelectObject (hdc, hCurrentPen);
     DrawPattern (hdc, cxClient, cyClient);
     SelectObject (hdc, hOldPen);
     EndPaint(hwnd, &ps);
     return (0);

    case WM_DESTROY :
     for (i = 0; i < 8; i++)
      {
       DeleteObject (hBrushes[i]);
       DeleteObject (hPens[i]);
      }

     for (i = 0; i < optionpie.n; i++)
      DeleteObject (optionpie.option[i].brush);

     for (i = 0; i < colorpie.n; i++)
      {
       DeleteObject (colorpie.option[i].brush);
       DeleteObject (backcolorpie.option[i].brush);
      }

     PostQuitMessage (0);
     return (0);
   }
  return (DefWindowProc(hwnd, message, wParam, lParam));
 }

/* ------------------------------------------------------------------ */

BOOL FAR PASCAL AboutDlgProc (HWND hDlg, WORD message, WORD wParam, LONG lParam)
 {
   switch (message)
    {
     case WM_INITDIALOG :
      return (TRUE);

     case WM_COMMAND :
      switch (wParam)
       {
	case IDOK :
	 EndDialog (hDlg, 0);
	 return (TRUE);
       }
      break;
    }
   return (FALSE);
 }

/* ------------------------------------------------------------------ */

void DrawPattern (HDC hdc, short width, short ht)
 {
   /* Draws the chords of a circle pattern in the rectangle whose size is
   ** width X ht. Pattern is drawn in the device whose Device Context is hdc.
   */
   static double AngularArc = DEG_TO_RADIANS * (360/ARCS);
   double angle1, angle2;
   short xc, yc, i, j, x1, y1, x2, y2, Radius;

   if (hdc != NULL && width > 0 && ht > 0)
    {
     xc = width/2; yc = ht/2;
     Radius = min (xc, yc);

     for (i = 1; i <= ARCS; i++)
      {
       angle1 = (i-1) * AngularArc;
       x1 = (int)(Radius * cos(angle1)) + xc;
       y1 = (int)(Radius * sin(angle1)) + yc;

       for (j = i+1; j <= ARCS; j++)
	{
	 angle2 = (j-1) * AngularArc;
	 x2 = (int)(Radius * cos(angle2)) + xc;
	 y2 = (int)(Radius * sin(angle2)) + yc;
	 MoveTo (hdc, x1, y1);
	 LineTo (hdc, x2, y2);
	}
      }
    }
 }

/* ------------------------------------------------------------------ */
