/* ------------------------------------------------
    PIEMENU.H -- header file for pie menu routines
		 (c) Carl C. Rollo, 1991,1992
   ------------------------------------------------ */

#define MAXOPTIONS 8
#define PI 3.14159265
#define TWO_PI (2 * PI)

#define WHITE   RGB (255, 255, 255)
#define BLACK   RGB (0,     0,   0)

typedef struct
 {
  char   *name;     /* label for this option */
  BOOL   showlabel; /* indicates whether label is to be displayed */
  BOOL   checked;   /* indicates when option is to be checked */
  short  value;     /* value to be returned if option is chosen */
  COLORREF color;   /* color of pie wedge for this option, default = WHITE */
  HBRUSH brush;     /* handle to brush for filling wedge with color */
  double maxangle;  /* angle of upper bound of option wedge */
  POINT  endarc;    /* coordinates of upper bound of option wedge arc */
  RECT   txt;       /* coords. of rectangle bounding text label */
 } PIE_OPTION;

typedef struct
 {
  short      radius;             /* radius of pie */
  short      no_choice;          /* value to be returned if no choice is made */
  short      n;                  /* number of options in menu */
  PIE_OPTION option[MAXOPTIONS]; /* data structures for each option */
  BOOL       InsideLabels;       /* switch to indicate if labels are to be
				 ** placed inside or outside the wedge */
  BOOL       UseChecks;          /* indicates when selection is to be checked */
 } PIE_MENU;
typedef PIE_MENU FAR * LPPIEMENUSTRUCT;

typedef struct
 {
  DWORD DCOrg;
  RECT  ClientRect;
  DWORD ViewportExt;
  DWORD ViewportOrg;
  DWORD WindowExt;
  DWORD WindowOrg;
 } VIEWWINDATA;
typedef VIEWWINDATA FAR * LPVIEWWINDATA;


extern BOOL CreatePieMenuIndirect (LPPIEMENUSTRUCT, short *, short *);
extern void DrawPieMenu (HDC, LPPIEMENUSTRUCT);
extern short PieMenuProc (LPVIEWWINDATA, LPPIEMENUSTRUCT);
extern LPVIEWWINDATA GetViewportWindowParms (HDC hDC);
extern BOOL DP_to_LP(LPVIEWWINDATA, LPPOINT, int);
