Unit Lists;

Interface

Type

  PAttr = ^Attr;
  Attr = record
    Attribute : array[0..40] of Char;
    ANext : PAttr;
  end;

  PItem = ^Item;
  Item = record
    ItemName : array[0..40] of Char;
    Prop : PAttr;
    Next : PItem;
  end;

  PList = ^SList;
  SList = object
    Node : PItem;
    constructor Init;
    destructor Done; virtual;
    procedure FreeList;
    procedure AddNode(var Head, Tail : PItem; NewName : PChar);
    function Search(Head : PItem; Name : PChar) : PItem;
    function GetAttr(Key : PChar) : PAttr;
  end;

  PNestedList = ^NestedList;
  NestedList = object(SList)
    NNode : PAttr;
    constructor Init;
    procedure FreeList;
    procedure NewNode(var AHead, ATail : PAttr; var Head, Tail : PItem;
                       IName, NewAttr : PChar);
    function Search(Head : PAttr; Attribute : PChar) : Boolean;
  end;

  function SearchItemList( Head : PItem; Attribute : PChar): String;

var
  ListPtr  : PItem;
  NListPtr : PAttr;


Implementation

Uses WinDOS, WObjects, WinTypes, Strings, WinProcs;

{ ----------------------- }
{ NestedList methods      }
{ ----------------------- }
constructor NestedList.Init;
begin
  NNode := nil;
end;

procedure NestedList.FreeList;
begin
  NNode := NListPtr;
  while NNode <> nil do
  begin
    Dispose(NNode);
    NNode := NNode^.ANext;
  end;
end;

procedure NestedList.NewNode (var AHead, ATail : PAttr; var Head, Tail : PItem;
                              IName, NewAttr : PChar);
var
  ANode : PAttr;
  LPtr : PItem;
begin
  LPtr := SList.Search(Head, IName);
  If LPtr = nil Then
  begin
    AddNode(Head, Tail, IName);
    New(ANode);
    AHead := ANode;
    ATail := ANode;
    ANode^.ANext := nil;
    StrCopy(ANode^.Attribute, NewAttr);
    LPtr := SList.Search(Head, IName);
    LPtr^.Prop := ANode;
  end
  Else {Item already exists-add ANode to existing}
  begin
    New(ANode);
    AHead := LPtr^.Prop;
    ATail^.ANext := ANode;
    ATail := ANode;
    ANode^.ANext := nil;
    StrCopy(ANode^.Attribute, NewAttr);
  end;
end;

function NestedList.Search ( Head : PAttr; Attribute : PChar) : Boolean;
var
  I : Integer;
begin
  Search := False;
  NNode := Head;
  While NNode <> nil do
  begin
    I := StrIComp(NNode^.Attribute, Attribute);
    If I = 0 then
    begin
      Search := True;
      Exit;
    end;
    NNode := NNode^.ANext;
  end;
end;

function SearchItemList( Head : PItem; Attribute : PChar): String;
var
  Node : PItem;
  ANode : PAttr;
  AttrList : NestedList;
begin
  Node := Head;
  ANode := Node^.Prop;
  SearchItemList := '';
  While Node <> nil do
  begin
    If not AttrList.Search(ANode, Attribute) then
    begin
      Node := Node^.Next;
      If Node <> nil Then
        ANode := Node^.Prop;
    end
    else
    begin
      SearchItemList := Node^.ItemName;
      Exit;
    end;
  end;
end;

{ ----------------------- }
{ List methods            }
{ ----------------------- }

constructor SList.Init;
begin
  ListPtr := nil;
  Node := nil;
end;

Destructor SList.Done;
begin
  FreeList;
end;

procedure SList.FreeList;
var
   AttrList : NestedList;
begin
  Node := ListPtr;
  while Node <> nil do
  begin
    NListPtr := Node^.Prop;
    Dispose(Node);
    AttrList.FreeList;
    Node := Node^.Next;
  end;

end;

{ Insert a New Item in the list }
procedure SList.AddNode (var Head, Tail : PItem; NewName : PChar);
var
  Added : PItem;
begin
  New(Added);
  If Head = nil then
  begin
    Head := Added;
    Tail := Added;
    ListPtr := Added;
  end
  Else begin
    Tail^.Next := Added;
    Tail := Added;
  end;
  Node := Head;
  Added^.Next := nil;
  StrCopy(Added^.ItemName, NewName);
end;

{ Search for a specified Item - return pointer if found }
function SList.Search ( Head : PItem; Name : PChar) : PItem;
var
  I : Integer;
begin
  Search := nil;
  Node := Head;
  While Node <> nil do
  begin
    I := StrIComp(Node^.ItemName, Name);
    If I = 0 then
    begin
      Search := Node;
      Exit;
    end;
    Node := Node^.Next;
  end;
end;

{Search for an Attribute and return pointer to its list}
function SList.GetAttr(Key : PChar) : PAttr;
var
  I : Integer;
Begin
  GetAttr := nil;
  Node := ListPtr;
  While Node <> nil do
  begin
    I := StrIComp(Node^.ItemName, Key);
    If I = 0 then
    begin
      GetAttr := Node^.Prop;
      Exit;
    end
    else
      Node := Node^.Next
  end;
end;
end.
