/*

Mark Test - Test Gc.GcPickUp

*/

#include "array.h"
#include "aseg.h"
#include "bool.h"
#include "gc.h"
#include "stdio.h"

FILE*	TraceFile;

struct AllocDescTg {
	void*		Block;
	Boolean		IsRef;
};

typedef struct AllocDescTg	AllocDesc;
typedef AllocDesc			AllocDescAry[];
typedef AllocDescAry*		AllocDescAryRef;

typedef void* (*RefAryRef)[];

RefAryRef SegInit(
	AllocSeg 		Seg			/* The segment to allocate from */
/*	AllocDescAryRef NotGcdSeg	/* We fill with info about what we alloc'd */
) {
	void* 			Block;		/* A block */
	unsigned 		DescPos;	/* Position is NotGcdSeg */
	RefAryRef		Result;		/* Our Result */

	Result = (RefAryRef)ASegAllocBlock( Seg, sizeof( (*Result)[0] ) * 400 );
	(*Result)[ 399 ] = NULL;
	for ( DescPos = 0; DescPos < 399;) {
		Block = ASegAllocBlock( Seg, 100 );
		(*Result)[DescPos] = Block;
		DescPos++;
		Block = ASegAllocBlock( Seg, 50 );
		Block = (void*)( (unsigned)Block + ( DescPos%50 ) + 1 );
		(*Result)[DescPos] = Block;
		DescPos++;
/*
		(*NotGcdSeg)[ DescPos*2   ].Block = (*Result)[DescPos];
		(*NotGcdSeg)[ DescPos*2   ].IsRef = True;
		(*NotGcdSeg)[ DescPos*2+1 ].Block = Block;
		(*NotGcdSeg)[ DescPos*2+1 ].IsRef = False;
*/
	}
	return Result;
}

int main(int argc, char** argv)
{
	RefAryRef		Refs;		/* Root of tree for mark test to find */
/*	AllocDescAryRef	NotGcdSeg;	/* Not looked at by GC */
	AllocSeg		Seg;		/* Segment to allocate from */

	TraceFile = fopen("trace.txt", "w");

	Seg = 0;
	ASegInitSeg( Seg );
/*	NotGcdSeg = (AllocDescAryRef)OsAllocSeg();
*/

	Refs = SegInit( Seg /*, NotGcdSeg*/ );
	fprintf( TraceFile, "Initialized Segment\n" );
	ASegDumpSeg( Seg, TraceFile );
	fprintf( TraceFile, "\n");

	GcPickUp( );
	fprintf( TraceFile, "Swept Segment \n" );
	ASegDumpSeg( Seg, TraceFile );

	return 0;
}

