/*

power2 - Functions whose range or domain is powers of 2.

For speed, some functions are implemented as arrays.  For these, the
argument must be between 0 and 255.

*/

#define MaxPwr2Div(X) ( (X) & -(X) )
	/*
	TRICK: Returns the largest power of two which can divide X
	without a remainder.  Due to the definition of negation, the
	only bit that X and -X share is the least significant 1 bit.
	This bit is also the max power of 2 divisor for X.
*/
extern unsigned short BumpUp[256];
extern unsigned short Log2[256];
