#include "bool.h"
#include "stdio.h"

void PrintTable(
	FILE*		CFile,
	char*		TableName,
	unsigned	Table[256],
	Boolean		IfDef
) {
	unsigned	Idx;

	if ( IfDef ) {
		fprintf( CFile, "#ifdef %s_Include\n", TableName );
	}
	fprintf( CFile, "unsigned short\t%s[256] = {\n", TableName );
	for ( Idx = 0; Idx < 256; Idx++ ) {
		fprintf( CFile, "\t%u\t/* %u */", Table[Idx], Idx );
		if (Idx < 255) {
			fprintf( CFile, ",\n" );
		} else {
			fprintf( CFile, "\n" );
		}
	}
	fprintf( CFile, "};\n");
	if ( IfDef ) {
		fprintf( CFile, "#endif /* %s_Include */\n", TableName );
	}
	fprintf( CFile, "\n");
}

main()
{
	unsigned	BumpUp[256];
	unsigned	BumpDown[256];
	FILE*		CFile;
	unsigned	Down;
	unsigned	DownLog2;
	unsigned	DownNext;
	unsigned	Idx;
	unsigned	Log;
	unsigned	Log2[256];
	unsigned	Up;

	Up = 1;
	Down = 1;
	DownLog2 = 0;
	DownNext = 2;
	BumpUp[0] =     0;
	BumpDown[0] =     0;
	for (Idx = 1; Idx < 256; Idx++) {
		if ( Idx == DownNext ) {
			Down = DownNext;
			DownLog2++;
			DownNext <<= 1;
		};

		BumpUp[Idx]   = Up;
		BumpDown[Idx] = Down;
		Log2[Idx] = DownLog2;

		if ( Up == Idx ) {
			Up <<= 1;
		};
	}

	CFile = fopen( "power2.c", "w" );
	fprintf( CFile, "/*\n" );
	fprintf( CFile, "\n" );
	fprintf( CFile,
		"power2 - Functions whose range or domain is powers of 2.\n"
	);
	fprintf( CFile, "\n" );
	fprintf( CFile,
		"For speed, the functions are implemented as arrays.  The argument must\n"
	);
	fprintf( CFile,
		"be between 0 and 255\n"
	);
	fprintf( CFile, "\n" );
	fprintf( CFile, "*/\n" );
	fprintf( CFile, "\n" );

	fprintf( CFile, "#include \"power2.h\"\n\n" );

	PrintTable( CFile, "BumpUp",     BumpUp,     False );
	PrintTable( CFile, "BumpDown",   BumpDown,   True );
	PrintTable( CFile, "Log2",       Log2,       False );

	return 0;
}
