/***************************************************************************

 FILENAME:		hwx_ad.c
 DESCRIPTION:   Browser attribute window source module for DDJ HWX example
				program.

****************************************************************************
	Copyright 1992 XVT Software Inc. All rights reserved.  XVT is a
	trademark of XVT Software Inc.

			XVT Software Inc., Box 18750, Boulder CO 80308 USA
					(303) 443-4223  fax: (303) 443-0969
***************************************************************************/

#include "xvt.h"
#include "hwx_bw.h"
#include "hwx_ad.h"
#include "hwx_glob.h"

/**************************************************************************/
WINDOW
AD_new (WINDOW BW_win)
{
	AD_DATA *AD_data_p;

	/* Allocate and populate a AD data object.
	 */
	if ((AD_data_p = (AD_DATA*)xvt_zmalloc (sizeof (AD_DATA))) == NULL) {
		xvt_error ("Cannot allocate attribute window data.");
	}
	AD_init (AD_data_p, BW_win);

	return (create_res_dialog (WD_MODAL, AD_RES, EM_ALL, AD_eh, (long)AD_data_p));
}

/**************************************************************************/
void
AD_init (AD_DATA *AD_data_p, WINDOW BW_win)
{
	DRAW_CTOOLS draw_ctools;
	BW_DATA *BW_data_p = (BW_DATA*)get_app_data (BW_win);

	AD_data_p->BW_win = BW_win;

	/* Save the BW drawing attributes in case we need to restore them.
	 */
	AD_data_p->saved_draw_ctools = BW_data_p->draw_ctools;
}

/**************************************************************************/
long
AD_eh (WINDOW win, EVENT *event_p)
{
	AD_DATA *AD_data_p = (AD_DATA*)get_app_data (win);
	BW_DATA *BW_data_p;
	char s[4];
	COLOR red, green, blue;

	BW_data_p = (BW_DATA*)get_app_data (AD_data_p->BW_win);

	switch (event_p->type) {
	case E_CREATE:

		AD_set_radiobuttons (win, AD_RADIOBUTTON_LCOLOR);

		/* Set the scrollbar ranges of the RGB and linewidth scrollbars.
		 */
		set_scroll_range (get_ctl_window (win, AD_HSCROLL_LW), HVSCROLL, LW_MIN, LW_MAX);
		set_scroll_range (get_ctl_window (win, AD_HSCROLL_R), HVSCROLL, CVAL_MIN, CVAL_MAX);
		set_scroll_range (get_ctl_window (win, AD_HSCROLL_G), HVSCROLL, CVAL_MIN, CVAL_MAX);
		set_scroll_range (get_ctl_window (win, AD_HSCROLL_B), HVSCROLL, CVAL_MIN, CVAL_MAX);

		/* Set the scrollbar positions, based on the current linewidth
		 * and linecolor.
		 */
		set_scroll_pos (get_ctl_window (win, AD_HSCROLL_LW), HVSCROLL,
						BW_data_p->draw_ctools.pen.width);

		AD_cvt_color_to_RGB (BW_data_p->draw_ctools.pen.color,
							 &red, &green, &blue);
		set_scroll_pos (get_ctl_window (win, AD_HSCROLL_R), HVSCROLL, (int)red);
		set_scroll_pos (get_ctl_window (win, AD_HSCROLL_G), HVSCROLL, (int)green);
		set_scroll_pos (get_ctl_window (win, AD_HSCROLL_B), HVSCROLL, (int)blue);

		/* Set the static text values which reflect the linecolor RGB and
		 * linewidth values.
		 */
		set_title (get_ctl_window (win, AD_TEXT_LWVAL),
				   itoa (BW_data_p->draw_ctools.pen.width, s, 10));
		set_title (get_ctl_window (win, AD_TEXT_REDVAL), itoa ((int)red, s, 10));
		set_title (get_ctl_window (win, AD_TEXT_GREENVAL), itoa ((int)green, s, 10));
		set_title (get_ctl_window (win, AD_TEXT_BLUEVAL), itoa ((int)blue, s, 10));
		break;

	case E_CONTROL:
		AD_control_eh (win, event_p->v.ctl.id, &(event_p->v.ctl.ci));
		break;

	case E_CLOSE:
		close_window (win);
		break;

	case E_DESTROY:
		xvt_free ((char*)get_app_data (win));
		break;

	default:
		break;
	}
	return (0L);
}

/**************************************************************************/
void
AD_control_eh (WINDOW win, short id, CONTROL_INFO *ci_p)
{
	WINDOW ctl_win, BW_win;
	AD_DATA *AD_data_p = (AD_DATA*)get_app_data (win);
	DRAW_CTOOLS BW_draw_ctools, tools;
	BW_DATA* BW_data_p;
	COLOR color;
	char s[4];
	short pos;
	WINDOW rbwin[2];

	BW_win = AD_data_p->BW_win;
	BW_data_p = (BW_DATA*)get_app_data (BW_win);
	BW_draw_ctools =  BW_data_p->draw_ctools;
	ctl_win = get_ctl_window (win, (int)id);

	switch (id) {
	case AD_BUTTON_OK:
		BW_do_attr_update (BW_win, AD_build_ctools (win, &BW_draw_ctools));
		close_window (win);
		break;

	case AD_BUTTON_APPLY:
		BW_do_attr_update (BW_win, AD_build_ctools (win, &BW_draw_ctools));
		break;

	case AD_BUTTON_DEFAULTS:
		AD_set_radiobuttons (win, AD_RADIOBUTTON_LCOLOR);

		AD_set_color (win, 0L);
		set_scroll_pos (get_ctl_window (win, AD_HSCROLL_LW), HVSCROLL, LW_MIN);
		set_title (get_ctl_window (win, AD_TEXT_LWVAL), itoa (LW_MIN, s, 10));

		BW_do_attr_update (BW_win, get_normal_ctools (&tools));
		break;

	case AD_BUTTON_CANCEL:
		BW_do_attr_update (BW_win, &(AD_data_p->saved_draw_ctools));
		close_window (win);
		break;

	case AD_RADIOBUTTON_LCOLOR:
		/* Convert the RGB values of the scrollbars to the background
		 * color, and set the RGB scrollbar values to the current line
		 * color values.
		 */
		AD_set_radiobuttons (win, AD_RADIOBUTTON_LCOLOR);

		AD_get_color (win, &color);
		BW_data_p->draw_ctools.brush.color = color;
		AD_set_color (win, BW_data_p->draw_ctools.pen.color);
		break;

	case AD_RADIOBUTTON_BCOLOR:
		/* Convert the RGB values of the scrollbars to the line
		 * color, and set the RGB scrollbar values to the current background
		 * color values.
		 */
		AD_set_radiobuttons (win, AD_RADIOBUTTON_BCOLOR);

		AD_get_color (win, &color);
		BW_data_p->draw_ctools.pen.color = color;
		AD_set_color (win, BW_data_p->draw_ctools.brush.color);
		break;

	case AD_HSCROLL_R:
		pos = AD_set_scroll_pos (ci_p->win, id, ci_p->v.scroll.what, ci_p->v.scroll.pos);
		set_title (get_ctl_window (win, AD_TEXT_REDVAL), itoa (pos, s, 10));
		break;

	case AD_HSCROLL_G:
		pos = AD_set_scroll_pos (ci_p->win, id, ci_p->v.scroll.what, ci_p->v.scroll.pos);
		set_title (get_ctl_window (win, AD_TEXT_GREENVAL), itoa (pos, s, 10));
		break;

	case AD_HSCROLL_B:
		pos = AD_set_scroll_pos (ci_p->win, id, ci_p->v.scroll.what, ci_p->v.scroll.pos);
		set_title (get_ctl_window (win, AD_TEXT_BLUEVAL), itoa (pos, s, 10));
		break;

	case AD_HSCROLL_LW:
		pos = AD_set_scroll_pos (ci_p->win, id, ci_p->v.scroll.what, ci_p->v.scroll.pos);
		set_title (get_ctl_window (win, AD_TEXT_LWVAL), itoa (pos, s, 10));
		break;

	default:
		break;
	}
}

/**************************************************************************/
PRIVATE DRAW_CTOOLS*
AD_build_ctools (WINDOW win, DRAW_CTOOLS *draw_ctools_p)
{
	COLOR color;
	DRAW_CTOOLS tools = *draw_ctools_p;

	/* Get the RGB values for either the line color or background color
	 * from the scrollbars, depending on the radiobutton that is ON.
	 * (The color for the other one will have already been set into the
	 * DRAW_CTOOLS of the BW.)  Convert to an XVT COLOR value, and set
	 * the color in the DRAW_CTOOLS object.  Also, get the value of the
	 * linewidth scrollbar too.
	 */
	AD_get_color (win, &color);

	if (get_checked_state (get_ctl_window (win, AD_RADIOBUTTON_LCOLOR)))
		tools.pen.color = color;
	else
		tools.brush.color = color;

	tools.pen.width = get_scroll_pos (get_ctl_window (win, AD_HSCROLL_LW),
									  HVSCROLL);
	*(draw_ctools_p) = tools;
	return (draw_ctools_p);
}

/**************************************************************************/
PRIVATE COLOR*
AD_get_color (WINDOW win, COLOR *color_p)
{
	COLOR red, green, blue;

	/* Get the values from the RGB scrollbars, and construct and return
	 * a COLOR value.
	 */
	red   = (COLOR)get_scroll_pos (get_ctl_window (win, AD_HSCROLL_R), HVSCROLL);
	green = (COLOR)get_scroll_pos (get_ctl_window (win, AD_HSCROLL_G), HVSCROLL);
	blue  = (COLOR)get_scroll_pos (get_ctl_window (win, AD_HSCROLL_B), HVSCROLL);

	*color_p = 0L;
	*color_p = (red << 16) | (green << 8) | blue;

	return (color_p);
}

/**************************************************************************/
PRIVATE void
AD_set_color (WINDOW win, COLOR color)
{
	COLOR red, green, blue;
	char s[4];

	AD_cvt_color_to_RGB (color, &red, &green, &blue);

	set_scroll_pos (get_ctl_window (win, AD_HSCROLL_R), HVSCROLL, (int)red);
	set_scroll_pos (get_ctl_window (win, AD_HSCROLL_G), HVSCROLL, (int)green);
	set_scroll_pos (get_ctl_window (win, AD_HSCROLL_B), HVSCROLL, (int)blue);

	set_title (get_ctl_window (win, AD_TEXT_REDVAL), itoa ((int)red, s, 10));
	set_title (get_ctl_window (win, AD_TEXT_GREENVAL), itoa ((int)green, s, 10));
	set_title (get_ctl_window (win, AD_TEXT_BLUEVAL), itoa ((int)blue, s, 10));
}

/**************************************************************************/
PRIVATE void
AD_cvt_color_to_RGB (COLOR color, COLOR* red_p, COLOR* green_p, COLOR* blue_p)
{
	*red_p   = (COLOR)((color & RED_MASK)   >> 16);
	*green_p = (COLOR)((color & GREEN_MASK) >> 8);
	*blue_p  = (COLOR)(color & BLUE_MASK);
}

/**************************************************************************/
PRIVATE void
AD_set_radiobuttons (WINDOW win, int which)
{
	WINDOW rbwin[2];

	rbwin[0] = get_ctl_window (win, AD_RADIOBUTTON_LCOLOR);
	rbwin[1] = get_ctl_window (win, AD_RADIOBUTTON_BCOLOR);

	if (which == AD_RADIOBUTTON_LCOLOR)
		win_check_radio_button (rbwin[0], rbwin, 2);
	else
		win_check_radio_button (rbwin[1], rbwin, 2);
}

/**************************************************************************/
PRIVATE int
AD_set_scroll_pos (WINDOW win, short id, SCROLL_CONTROL what, short pos)
{
	short cur_pos, new_pos;
	int sc_min, sc_max, sc_page_inc, sc_line_inc;

	get_scroll_range (win, HVSCROLL, &sc_min, &sc_max);
	cur_pos = get_scroll_pos (win, HVSCROLL);

	if (id == AD_HSCROLL_LW) {
		sc_line_inc = LW_SC_LINE_INC;
		sc_page_inc = LW_SC_PAGE_INC;
	}
	else {
		sc_line_inc = CVAL_SC_LINE_INC;
		sc_page_inc = CVAL_SC_PAGE_INC;
	}

	switch (what) {
	case SC_NONE:
		break;

	case SC_LINE_UP:
		new_pos = cur_pos - sc_line_inc;
		if (new_pos < sc_min)
			new_pos = sc_min;
		break;

	case SC_LINE_DOWN:
		new_pos = cur_pos + sc_line_inc;
		if (new_pos > sc_max)
			new_pos = sc_max;
		break;

	case SC_PAGE_UP:
		new_pos = cur_pos - sc_page_inc;
		if (new_pos < sc_min)
			new_pos = sc_min;
		break;

	case SC_PAGE_DOWN:
		new_pos = cur_pos + sc_page_inc;
		if (new_pos > sc_max)
			new_pos = sc_max;
		break;

	case SC_THUMB:
	case SC_THUMBTRACK:
		new_pos = pos;
		break;

	default:
		break;
	}
	set_scroll_pos (win, HVSCROLL, new_pos);
	return (new_pos);
}