/***************************************************************************

 FILENAME:		hwx_ad.h
 DESCRIPTION:   Header file for attribute dialog module hwx_ad.c

****************************************************************************
	Copyright 1992 XVT Software Inc. All rights reserved.  XVT is a
	trademark of XVT Software Inc.

			XVT Software Inc., Box 18750, Boulder CO 80308 USA
					(303) 443-4223  fax: (303) 443-0969
***************************************************************************/

#include "xvt.h"
#include "hwx.h"
#include "hwx_glob.h"

#ifndef HWX_AD_H
#define HWX_AD_H

#define RED_MASK    0x00ff0000L
#define GREEN_MASK  0x0000ff00L
#define BLUE_MASK   0x000000ffL

#define LW_MIN	   1
#define LW_MAX     6

#define CVAL_MIN   0
#define CVAL_MAX 255

#define CVAL_SC_LINE_INC  1
#define CVAL_SC_PAGE_INC  20

#define LW_SC_LINE_INC  1
#define LW_SC_PAGE_INC  1

/***************************
 DATA STRUCTURE DEFINITIONS
***************************/

typedef struct {
	WINDOW BW_win;
	DRAW_CTOOLS saved_draw_ctools;
} AD_DATA;

/**********************
 FUNCTION DECLARATIONS
**********************/

PUBLIC_FCN  WINDOW AD_new (WINDOW);
PUBLIC_FCN  long AD_eh (WINDOW, EVENT*);

PRIVATE_FCN void AD_init (AD_DATA*, WINDOW);
PRIVATE_FCN void AD_control_eh (WINDOW, short, CONTROL_INFO*);
PRIVATE_FCN DRAW_CTOOLS* AD_build_ctools (WINDOW, DRAW_CTOOLS*);
PRIVATE_FCN COLOR* AD_get_color (WINDOW, COLOR*);
PRIVATE_FCN void AD_set_color (WINDOW, COLOR);
PRIVATE_FCN void AD_cvt_color_to_RGB (COLOR, COLOR*, COLOR*, COLOR*);
PRIVATE_FCN void AD_set_radiobuttons (WINDOW, int);
PRIVATE_FCN int AD_set_scroll_pos (WINDOW, short, SCROLL_CONTROL, short);

#endif /* HWX_AD_H */