/***************************************************************************

 FILENAME:		hwx_bw.h
 DESCRIPTION:   Header file for browser window module hwx_bw.c

****************************************************************************
	Copyright 1992 XVT Software Inc. All rights reserved.  XVT is a
	trademark of XVT Software Inc.

			XVT Software Inc., Box 18750, Boulder CO 80308 USA
					(303) 443-4223  fax: (303) 443-0969
***************************************************************************/

#ifndef HWX_BW_H
#define HWX_BW_H

#include "xvt.h"
#include "hwx.h"
#include "hwx_glob.h"
#include "hwx_ev.h"

#include "h_config.h"
#include "h_stddef.h"
#include "h_grafic.h"


#define FILE_SIGNATURE 0x2121
#define MAX_CHARS 256
#define EOF_FLAG -1
#define NO_CHANGE -1

#define NO_OPTIMIZE -1
#define OPTIMIZE 	-2

#define BW_SIZE_EV 11

/***************************
 DATA STRUCTURE DEFINITIONS
***************************/

typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef WINDOW HDISPLAY;
typedef void *GenericT;

typedef struct tagList {
	int num_items;
	GenericT items[1];
} List;

typedef List* lpList;
typedef lpList* lplpList;

typedef struct {
	EV *ev;
	FILE *file_p;
	FILE_SPEC fs;
	lplpList hwx_data;
	int cur_char;
	WINDOW BWI_win;
	WINDOW BWZ_win;
	DRAW_CTOOLS draw_ctools;
	BOOLEAN init_flag;
} BW_DATA;

/**********************
 FUNCTION DECLARATIONS
**********************/

PUBLIC_FCN  WINDOW BW_new (WINDOW);
PUBLIC_FCN  void BW_do_status_update (WINDOW);
PUBLIC_FCN  void BW_do_attr_update (WINDOW, DRAW_CTOOLS*);

PRIVATE_FCN void BW_ev_register (BW_DATA*);
PRIVATE_FCN void BW_init (WINDOW, lplpList, int);
PRIVATE_FCN BOOLEAN BW_open_file (BW_DATA*);

PRIVATE_FCN long BW_create_eh (WINDOW, EVENT*);
PRIVATE_FCN long BW_focus_eh (WINDOW, EVENT*);
PRIVATE_FCN long BW_update_eh (WINDOW, EVENT*);
PRIVATE_FCN long BW_destroy_eh (WINDOW, EVENT*);
PRIVATE_FCN long BW_propagate_eh (WINDOW, EVENT*);
PRIVATE_FCN long BW_command_file_print_eh (WINDOW, EVENT*);
PRIVATE_FCN long BW_command_opt_attrs_eh (WINDOW, EVENT*);
PRIVATE_FCN long BW_control_zoomin_eh (WINDOW, EVENT*);
PRIVATE_FCN long BW_control_zoomout_eh (WINDOW, EVENT*);
PRIVATE_FCN long BW_control_editchar_eh (WINDOW, EVENT*);

PRIVATE_FCN void BW_paint (WINDOW);
PRIVATE_FCN lplpList BW_load_data (WINDOW, FILE*);
PRIVATE_FCN void BW_free_data (WINDOW);
PRIVATE_FCN BOOLEAN BW_read_file_header (FILE*);
PRIVATE_FCN INT16 BW_read_file_word (FILE*);

#endif /* HWX_BW */