/***************************************************************************

 FILENAME:		hwx_bwi.c
 DESCRIPTION:   Browser "instance" window source module for DDJ HWX example
				program.

****************************************************************************
	Copyright 1992 XVT Software Inc. All rights reserved.  XVT is a
	trademark of XVT Software Inc.

			XVT Software Inc., Box 18750, Boulder CO 80308 USA
					(303) 443-4223  fax: (303) 443-0969
***************************************************************************/

#include "xvt.h"
#include "hwx_bw.h"
#include "hwx_bwz.h"
#include "hwx_bwi.h"
#include "hwx_glob.h"
#include "hwx_util.h"

/**************************************************************************/
WINDOW
BWI_new (WINDOW parent_win, int cur_char, int cur_instance)
{
	BWI_DATA *BWI_data_p;
	RCT BWI_rct;

	/* Allocate and populate a BWI data object.
	 */
	if ((BWI_data_p = (BWI_DATA*)xvt_zmalloc (sizeof (BWI_DATA))) == NULL) {
		xvt_error ("Cannot allocate browser instance window data.");
	}
	BWI_init (BWI_data_p, cur_char, cur_instance);

	BWI_rct.top    = BWI_RCT_TOP;
	BWI_rct.left   = BWI_RCT_LEFT;
	BWI_rct.bottom = BWI_RCT_BOTTOM;
	BWI_rct.right  = BWI_RCT_RIGHT;

	return (create_window (W_PLAIN,
						   &BWI_rct,
						   NULL,
						   0,
						   parent_win,
						   WSF_NONE,
						   EM_ALL,
						   BWI_eh,
						   (long)BWI_data_p));
}

/**************************************************************************/
void
BWI_init (BWI_DATA *BWI_data_p, int cur_char, int cur_instance)
{
	BWI_data_p->cur_char = cur_char;
	BWI_data_p->cur_instance = cur_instance;
	BWI_data_p->instance_opt_flag = NO_OPTIMIZE;
}

/**************************************************************************/
long
BWI_eh (WINDOW win, EVENT *event_p)
{
	switch (event_p->type) {
	case E_CREATE:
		break;

	case E_UPDATE:
		BWI_paint (win);
		break;

	case E_MOUSE_UP:
		/* Signifies the selection of one of the instance table entries.
		 */
		BWI_table_selection (win, event_p->v.mouse.where.v,
								  event_p->v.mouse.where.h);
		break;

	case E_CLOSE:
		close_window (win);
		break;

	case E_DESTROY:
		xvt_free ((char*)get_app_data (win));
		break;

	default:
		break;
	}
	return (0L);
}

/**************************************************************************/
void
BWI_paint (WINDOW win)
{
	BWI_DATA *BWI_data_p = (BWI_DATA*)get_app_data (win);
	BW_DATA *BW_data_p = (BW_DATA*)get_app_data (get_parent (win));

	/* NOTE: Clipping will always be set automatically.
	 */
	if (BWI_data_p->instance_opt_flag == NO_OPTIMIZE)
		clear_window (win, (COLOR)get_value (NULL_WIN, ATTR_BACK_COLOR));

	/* Get the drawing tools from the parent window.
	 */
	win_set_draw_ctools (win, &(BW_data_p->draw_ctools));
	BWI_draw_instance_table (win);

	BWI_data_p->instance_opt_flag = NO_OPTIMIZE;
}

/****************************************************************/
PRIVATE void
BWI_draw_instance_table (WINDOW win)
{
	INT16 i, j;
	BWI_DATA *BWI_data_p = (BWI_DATA*)get_app_data (win);
	BW_DATA *BW_data_p = (BW_DATA*)get_app_data (get_parent (win));
	lplpList hwx_data;
	int cur_char;

	hwx_data = BW_data_p->hwx_data;
	cur_char = BWI_data_p->cur_char;

	wait_cursor();

	for (j = 0; j < hwx_data[cur_char]->num_items; j++)
	{
		if (BWI_data_p->instance_opt_flag != NO_OPTIMIZE) {
			if ((j == BWI_data_p->instance_opt_flag) ||
				(j == BWI_data_p->cur_instance))
				BWI_draw_instance_in_table (win, j, hwx_data[cur_char]->items[j]);
		}
		else
			BWI_draw_instance_in_table (win, j, hwx_data[cur_char]->items[j]);
	}
}

/**************************************************************************/
PRIVATE void
BWI_draw_instance_in_table (WINDOW win, int instance_num,
							lpList char_instance)
{
	BWI_DATA *BWI_data_p = (BWI_DATA*)get_app_data (win);
	int cur_char, cur_instance;

	INT16 hshift,vshift;
	Rect bbox_tab;  /* in world/object/tablet coordinates */
	Rect bbox_scr;  /* in screen coordinates */
	Rect bbox_out;  /* shifted for output */
	Rect r;

	short win_left, win_top;
	RCT win_rct, rct;

	/* Get the BWI window metrics, and pull some data out of the BWI
	 * data object.
	 */
	get_client_rect (win, &win_rct);
	win_left   = win_rct.left;
	win_top    = win_rct.top;

	cur_char = BWI_data_p->cur_char;
	cur_instance = BWI_data_p->cur_instance;

	hshift = (instance_num % NUM_INST_PER_ROW) * CELL_WIDTH;
	vshift = (instance_num / NUM_INST_PER_ROW) * CELL_HEIGHT;
	hshift += win_left;
	vshift += win_top;

	UTIL_calc_bbox (win, char_instance, &bbox_tab);

	bbox_scr = bbox_tab; /*structure copy */

	gr_SetTabToScrConversion (3,3);
	gr_ConvertRectTabletToScreen (&bbox_scr);
	gr_SetRect (&bbox_out, hshift, vshift, hshift+CELL_WIDTH, vshift+CELL_HEIGHT);

/*	gr_SetColorWhite(); */
	gr_DrawRect (win, &bbox_out);

	if (instance_num == cur_instance)
	{
		r = bbox_out;
		gr_InflateRect (&r, -3);
/*		gr_SetColorBlue(); */
		gr_DrawRect (win, &r);
	}

	hshift += ((CELL_WIDTH  - (bbox_scr.right  - bbox_scr.left)) / 2);
	vshift += ((CELL_HEIGHT - (bbox_scr.bottom - bbox_scr.top )) / 2);

	gr_SetRect (&bbox_out, hshift, vshift, hshift+ (bbox_scr.right  - bbox_scr.left),
										   vshift+ (bbox_scr.bottom - bbox_scr.top));
/*	gr_SetColorGray(); */
	gr_DrawRect (win, &bbox_out);
/*	gr_SetColorYellow(); */

	UTIL_draw_norm_instance (win, char_instance, &bbox_tab, hshift, vshift);
}

/**************************************************************************/
PRIVATE void
BWI_table_selection (WINDOW win, short v, short h)
{
	int sel_instance;
	BWI_DATA *BWI_data_p = (BWI_DATA*)get_app_data (win);
	BW_DATA *BW_data_p = (BW_DATA*)get_app_data (get_parent (win));

	sel_instance = (h / CELL_WIDTH) + ((v / CELL_HEIGHT) * NUM_INST_PER_ROW);

	/* Tell the BW, BWZ and BWI windows to "update" themselves with current
	 * data.
	 */
	BWZ_do_update (BW_data_p->BWZ_win, NO_CHANGE, sel_instance);
	BWI_do_update (win, NO_CHANGE, sel_instance, OPTIMIZE);
	BW_do_status_update (get_parent (win));

	return;
}

/**************************************************************************/
PUBLIC void
BWI_do_update (WINDOW win, int cur_char, int cur_instance,
			   int instance_opt_flag)
{
	BWI_DATA *BWI_data_p = (BWI_DATA*)get_app_data (win);

	if (cur_char != NO_CHANGE)
		BWI_data_p->cur_char = cur_char;

	if (instance_opt_flag == OPTIMIZE)
		BWI_data_p->instance_opt_flag = BWI_data_p->cur_instance;
	else
		BWI_data_p->instance_opt_flag = NO_OPTIMIZE;

	if (cur_instance != NO_CHANGE)
		BWI_data_p->cur_instance = cur_instance;

	invalidate_rect (win, (RCT*)NULL);
}