/***************************************************************************

 FILENAME:		hwx_bwi.h
 DESCRIPTION:   Header file for browser "instance" window module hwx_bwi.c

****************************************************************************
	Copyright 1992 XVT Software Inc. All rights reserved.  XVT is a
	trademark of XVT Software Inc.

			XVT Software Inc., Box 18750, Boulder CO 80308 USA
					(303) 443-4223  fax: (303) 443-0969
***************************************************************************/

#include "xvt.h"
#include "hwx.h"
#include "hwx_bw.h"
#include "hwx_glob.h"

#ifndef HWX_BWI_H
#define HWX_BWI_H

#define BWI_RCT_TOP  	33		/* BWI window coords */
#define BWI_RCT_LEFT    217
#define BWI_RCT_BOTTOM  353
#define BWI_RCT_RIGHT   617

#define NUM_INST_PER_ROW 5
#define NUM_INST_PER_COL 4

#define CELL_WIDTH   80
#define CELL_HEIGHT  80

/***************************
 DATA STRUCTURE DEFINITIONS
***************************/

typedef struct {
	int cur_char;
	int cur_instance;
	int instance_opt_flag;
} BWI_DATA, *BWI_DATA_P;

/**********************
 FUNCTION DECLARATIONS
**********************/

PUBLIC_FCN  WINDOW BWI_new (WINDOW, int, int);
PUBLIC_FCN  long BWI_eh (WINDOW, EVENT*);
PUBLIC_FCN  void BWI_do_update (WINDOW, int, int, int);

PRIVATE_FCN void BWI_init (BWI_DATA_P, int, int);
PRIVATE_FCN void BWI_paint (WINDOW);
PRIVATE_FCN void BWI_draw_instance_table (WINDOW);
PRIVATE_FCN void BWI_draw_instance_in_table (WINDOW, int, lpList);
PRIVATE_FCN void BWI_table_selection (WINDOW, short, short);

#endif /* HWX_BWI_H */