/***************************************************************************

 FILENAME:		hwx_bwz.c
 DESCRIPTION:   Browser "zoom" window source module for DDJ HWX example
				program.

****************************************************************************
	Copyright 1992 XVT Software Inc. All rights reserved.  XVT is a
	trademark of XVT Software Inc.

			XVT Software Inc., Box 18750, Boulder CO 80308 USA
					(303) 443-4223  fax: (303) 443-0969
***************************************************************************/

#include "xvt.h"
#include "hwx_bwz.h"
#include "hwx_glob.h"
#include "hwx_util.h"

/**************************************************************************/
WINDOW
BWZ_new (WINDOW parent_win, int cur_char, int cur_instance)
{
	BWZ_DATA *BWZ_data_p;
	RCT BWZ_rct;

	/* Allocate and populate a BWZ data object.
	 */
	if ((BWZ_data_p = (BWZ_DATA*)xvt_zmalloc (sizeof (BWZ_DATA))) == NULL) {
		xvt_error ("Cannot allocate browser zoom window data.");
	}
	BWZ_init (BWZ_data_p, cur_char, cur_instance);

	BWZ_rct.top    = BWZ_RCT_TOP;
	BWZ_rct.left   = BWZ_RCT_LEFT;
	BWZ_rct.bottom = BWZ_RCT_BOTTOM;
	BWZ_rct.right  = BWZ_RCT_RIGHT;

	return (create_window (W_PLAIN,
						   &BWZ_rct,
						   NULL,
						   0,
						   parent_win,
						   WSF_NONE,
						   EM_ALL,
						   BWZ_eh,
						   (long)BWZ_data_p));
}

/**************************************************************************/
void
BWZ_init (BWZ_DATA *BWZ_data_p, int cur_char, int cur_instance)
{
	BWZ_data_p->cur_char = cur_char;
	BWZ_data_p->cur_instance = cur_instance;
	BWZ_data_p->zoom_factor = BWZ_ZOOMOUT_FACTOR;
}

/**************************************************************************/
long
BWZ_eh (WINDOW win, EVENT *event_p)
{
	switch (event_p->type) {
	case E_CREATE:
		clear_window (win, (COLOR)get_value (NULL_WIN, ATTR_BACK_COLOR));
		break;

	case E_UPDATE:
		BWZ_paint (win);
		break;

	case E_CLOSE:
		close_window (win);
		break;

	case E_DESTROY:
		xvt_free ((char*)get_app_data (win));
		break;

	default:
		break;
	}
	return (0L);
}

/**************************************************************************/
void
BWZ_paint (WINDOW win)
{
	BWZ_DATA *BWZ_data_p = (BWZ_DATA*)get_app_data (win);
	BW_DATA *BW_data_p = (BW_DATA*)get_app_data (get_parent (win));

	/* NOTE: Clipping will always be set automatically.
	 */
	win_set_draw_ctools (win, &(BW_data_p->draw_ctools));
	BWZ_draw_instance (win);
}

/**************************************************************************/
void
BWZ_draw_instance (WINDOW win)
{
	BWZ_DATA *BWZ_data_p = (BWZ_DATA*)get_app_data (win);
	BW_DATA *BW_data_p = (BW_DATA*)get_app_data (get_parent (win));

	lplpList hwx_data;
	int cur_char, cur_instance;

	INT16 hshift,vshift;
	Rect bbox_tab;  /* in world/object/tablet coordinates */
	Rect bbox_scr;  /* in screen coordinates */
	Rect bbox_out;  /* shifted for output */

	lpList char_instance;

	short win_left, win_top, win_right, win_bottom, win_width, win_height;
	RCT win_rct, rct;

	/* Initialize all of the window metrics, and retrieve the HWX data pointer
	 * and the current character and instance data.
	 */
	get_client_rect (win, &win_rct);
	win_left   = win_rct.left;
	win_top    = win_rct.top;
	win_right  = win_rct.right;
	win_bottom = win_rct.bottom;
	win_width  = win_right - win_left;
	win_height = win_bottom - win_top;

	cur_char     = BWZ_data_p->cur_char;
	cur_instance = BWZ_data_p->cur_instance;
	hwx_data     = BW_data_p->hwx_data;

	if (hwx_data[cur_char] == NULL)
		return;

	char_instance = hwx_data[cur_char]->items[cur_instance];

	hshift = win_left;
	vshift = win_top;

	gr_SetTabToScrConversion (BWZ_data_p->zoom_factor,
							  BWZ_data_p->zoom_factor);

	UTIL_calc_bbox (win, char_instance, &bbox_tab);

	bbox_scr = bbox_tab;
	gr_ConvertRectTabletToScreen (&bbox_scr);

	gr_SetRect (&bbox_out, hshift, vshift, hshift + win_width, vshift + win_height);

/*	gr_SetColorWhite(); */
	gr_DrawRect (win, &bbox_out);

	hshift += ((win_width  - (bbox_scr.right  - bbox_scr.left)) / 2);
	vshift += ((win_height - (bbox_scr.bottom - bbox_scr.top )) / 2);

	gr_SetRect (&bbox_out, hshift, vshift,
				hshift+ (bbox_scr.right  - bbox_scr.left),
				vshift+ (bbox_scr.bottom - bbox_scr.top));

/*	gr_SetColorGray(); */
	gr_DrawRect (win, &bbox_out);
/*	gr_SetColorYellow(); */

	UTIL_draw_norm_instance (win, char_instance, &bbox_tab, hshift, vshift);
}

/**************************************************************************/
PUBLIC void
BWZ_do_update (WINDOW win, int cur_char, int cur_instance)
{
	BWZ_DATA *BWZ_data_p = (BWZ_DATA*)get_app_data (win);

	if (cur_char != NO_CHANGE)
		BWZ_data_p->cur_char = cur_char;

	if (cur_instance != NO_CHANGE)
		BWZ_data_p->cur_instance = cur_instance;

	invalidate_rect (win, (RCT*)NULL);
}

/**************************************************************************/
PUBLIC void
BWZ_do_zoom (WINDOW win, int zoom_type)
{
	BWZ_DATA *BWZ_data_p = (BWZ_DATA*)get_app_data (win);

	BWZ_data_p->zoom_factor = zoom_type;
	invalidate_rect (win, NULL);
}