/***************************************************************************

 FILENAME:		hwx_bwz.h
 DESCRIPTION:   Header file for browser "zoom" window module hwx_bwz.c

****************************************************************************
	Copyright 1992 XVT Software Inc. All rights reserved.  XVT is a
	trademark of XVT Software Inc.

			XVT Software Inc., Box 18750, Boulder CO 80308 USA
					(303) 443-4223  fax: (303) 443-0969
***************************************************************************/

#include "xvt.h"
#include "hwx.h"
#include "hwx_bw.h"
#include "hwx_glob.h"

#include "h_config.h"
#include "h_stddef.h"

#ifndef HWX_BWZ_H
#define HWX_BWZ_H

#define BWZ_RCT_TOP		115
#define BWZ_RCT_LEFT    8
#define BWZ_RCT_BOTTOM  341
#define BWZ_RCT_RIGHT   207

#define BWZ_ZOOMIN_FACTOR	1
#define BWZ_ZOOMOUT_FACTOR	2

/***************************
 DATA STRUCTURE DEFINITIONS
***************************/

typedef struct {
	int cur_char;
	int cur_instance;
	int zoom_factor;
} BWZ_DATA;

/**********************
 FUNCTION DECLARATIONS
**********************/

PUBLIC_FCN  WINDOW BWZ_new (WINDOW, int, int);
PUBLIC_FCN  long BWZ_eh (WINDOW, EVENT*);
PUBLIC_FCN  void BWZ_do_update (WINDOW, int, int);
PUBLIC_FCN  void BWZ_do_zoom (WINDOW, int);

PRIVATE_FCN void BWZ_init (BWZ_DATA*, int, int);
PRIVATE_FCN void BWZ_paint (WINDOW);
PRIVATE_FCN void BWZ_draw_instance (WINDOW);


#endif /* HWX_BWZ_H */