/***************************************************************************

 FILENAME:		hwx_ev.c
 DESCRIPTION:   Generic event handler source module for DDJ HWX example
				program.

****************************************************************************
	Copyright 1992 XVT Software Inc. All rights reserved.  XVT is a
	trademark of XVT Software Inc.

			XVT Software Inc., Box 18750, Boulder CO 80308 USA
					(303) 443-4223  fax: (303) 443-0969
***************************************************************************/

#include "hwx_glob.h"
#include "hwx.h"
#include "hwx_ev.h"

/**************************************************************************/
PUBLIC EV*
EV_create (int num_eh)
{
	EV *ev = NULL;

	if ((ev = (EV*)xvt_zmalloc (sizeof (EV) * (num_eh + 1))) == NULL)
		xvt_error ("Cannot allocate EV event vector.");
	else
		ev[num_eh].type = EV_END;  /* signal for end-of-array */

	return (ev);
}

/**************************************************************************/
PUBLIC void
EV_set_eh (EV *ev, int index, EVENT_TYPE type, long i, EH eh)
{
	ev[index].type = type;

	if (type == E_COMMAND)
		ev[index].val = (MENU_TAG)i;
	else if (type == E_CONTROL)
		ev[index].val = (short)i;

	ev[index].eh = eh;
}

/***********************************************************************/
PUBLIC long
EV_eh (WINDOW win, EVENT *ev_p)
{
	EV **ev = (EV*)get_app_data (win);
	EH eh;
	long ev_action, val = 0;

	if (ev_p->type == E_COMMAND)
		val = (long)(ev_p->v.cmd.tag);
	else if (ev_p->type == E_CONTROL)
		val = (long)(ev_p->v.ctl.id);

	eh = EV_lookup (*ev, ev_p->type, val);

	if (eh != NULL) {
		ev_action = (*eh) (win, ev_p);
		if ((ev_action == EV_PROPAGATE) || (ev_action == EV_CONSUMED_AND_PROPAGATE))
			dispatch_event (get_parent (win), ev_p);
		return (0L);
	}
	/* If there were no event handlers registered for certain events,
	 * this is where we perform some basic default behaviors.
	 */
	switch (ev_p->type) {
	case E_CLOSE:				/* DEFAULT */
		close_window (win);
		break;

	case E_DESTROY:             /* DEFAULT */
		xvt_free (ev);
		xvt_free ((char*)get_app_data (win));
		break;

	case E_COMMAND:             /* DEFAULT */
		if (ev_p->v.cmd.tag == M_FILE_QUIT)
			close_window (win);
		else
			xvt_note ("Sorry...the menu item you selected has not yet been implmented.");
		break;

	default:
		break;
	}
	return (0L);
}

/**************************************************************************/
PRIVATE EH
EV_lookup (EV *ev, EVENT_TYPE type, long i)
{
	int index;

	for (index = 0; ev[index].type != EV_END; index++) {
		if ((type == E_COMMAND && ev[index].type == E_COMMAND) ||
			(type == E_CONTROL && ev[index].type == E_CONTROL)) {

			if (ev[index].val == i)
				return (ev[index].eh);
		}
		else if (type == ev[index].type)
			return (ev[index].eh);
	}
	return (NULL);
}