/***************************************************************************

 FILENAME:		hwx_ev.h
 DESCRIPTION:   Header file for event handler module hwx_bw.c

****************************************************************************
	Copyright 1992 XVT Software Inc. All rights reserved.  XVT is a
	trademark of XVT Software Inc.

			XVT Software Inc., Box 18750, Boulder CO 80308 USA
					(303) 443-4223  fax: (303) 443-0969
***************************************************************************/

#ifndef HWX_EV_H
#define HWX_EV_H

#include "hwx.h"
#include "hwx_glob.h"


#define EV_CONSUMED				   1L
#define EV_CONSUMED_AND_PROPAGATE  2L
#define EV_PROPAGATE	   	       3L

#define EV_END ((EVENT_TYPE)9999)

/***************************
 DATA STRUCTURE DEFINITIONS
***************************/

typedef long (*EH)(WINDOW win, EVENT *ev_p);

typedef struct {
	EVENT_TYPE type;
	long val;
	EH eh;
} EV, *EV_P;

/**********************
 FUNCTION DECLARATIONS
**********************/

PUBLIC_FCN EV* EV_create (int);
PUBLIC_FCN void EV_set_eh (EV*, int, EVENT_TYPE, long, EH);
PUBLIC_FCN long EV_eh (WINDOW, EVENT*);

PRIVATE_FCN EH EV_lookup (EV*, EVENT_TYPE, long);

#endif   /* HWX_EV_H */
