/***************************************************************************

 FILENAME:		hwx_gr.h
 DESCRIPTION:   Header for hwx_gr.c

****************************************************************************
	Copyright 1992 XVT Software Inc. All rights reserved.  XVT is a
	trademark of XVT Software Inc.

			XVT Software Inc., Box 18750, Boulder CO 80308 USA
					(303) 443-4223  fax: (303) 443-0969
***************************************************************************/

#ifndef HWX_GR_H
#define HWX_GR_H

#include "xvt.h"
#include "hwx.h"
#include "hwx_glob.h"

#define FILE_SIGNATURE 0x2121

#define MAX_CHARS 256

GLOBAL lpList  CharData[MAX_CHARS];
GLOBAL jmp_buf main_loop;
GLOBAL long num_bytes = 0;

public  bool graphics_enabled = FALSE;

/***************************
 DATA STRUCTURE DEFINITIONS
***************************/

typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef WINDOW HDISPLAY;

/**********************
 FUNCTION DECLARATIONS
**********************/

public void LoadHWXData(LPSTR name);
public int  GetInstanceCount(int ch);
public void DisplayInstance(int char_code,int instance_num);
public void UnloadHWXData(void);
public lpList GetInstanceData(int ch,int inst);

private void (*pf_MoveTo)(WINDOW, INT16, INT16);
private void (*pf_LineTo)(WINDOW, INT16, INT16);

public void RegisterCallback (WINDOW win, void (*pf_move_to)(), void (*pf_line_to)());

private void XVT_MoveTo (WINDOW win, INT16 h, INT16 v);
private void XVT_LineTo (WINDOW win, INT16 h, INT16 v);

private INT16 ReadWordFromFile (FILE *data_file);
private void  ParseDataFormat (FILE *data_file);
private void  FreeMemStructures (void);
private void  ShowAllChars (INT16 begin,INT16 end);
private void  FatalError (char* msg);
private void  ShowInstanceInTable (int num_proto,lpList char_instance);
private bool  PickSetOfInstances (void);
private void  ShowSetOfInstances (INT16 ch);
private void  CalcInstanceBoundingBox (lpList char_instance,lpRect bbox);
private void  NormalizeAnInstance (lpList char_instance,lpRect bbox);
private void  NormalizeAndDisplayInstance (lpList char_instance, lpRect bbox,
										   INT16 hshift, INT16 vshift,
										   bool use_callbacks);
private void  ShowUsage (void);
private void  ShowHeading (int char_code, int instance_num);


#endif /* HWX_TW_H */