/***************************************************************************

 FILENAME:		hwx_tw.c
 DESCRIPTION:   Task window (main) program source module for DDJ HWX example program.

****************************************************************************
	Copyright 1992 XVT Software Inc. All rights reserved.  XVT is a
	trademark of XVT Software Inc.

			XVT Software Inc., Box 18750, Boulder CO 80308 USA
					(303) 443-4223  fax: (303) 443-0969
***************************************************************************/

#include "xvt.h"
#include "hwx_tw.h"
#include "hwx_bw.h"
#include "hwx_ev.h"


/**************************************************************************/
/* This function is the equivalent of what would be TW_new().             */
/**************************************************************************/
void
main (int argc, char *argv[])
{
	XVT_CONFIG config;

	set_value ((WINDOW)NULL, ATTR_WIN_MDI, (long)TRUE);
	set_value ((WINDOW)NULL, ATTR_SUPPRESS_UPDATE_CHECK, (long)TRUE);

	memset (&config, 0, sizeof (XVT_CONFIG));

	config.menu_bar_ID = TW_MENUBAR;
	config.about_box_ID = ABD_DEF;
	config.base_appl_name = "hwx";
	config.appl_name = "HWX";
	config.taskwin_title = "XVT HWX";

	xvt_system (argc, argv, 0L, TW_eh, &config);
}

/**************************************************************************/
PRIVATE long
TW_eh (WINDOW win, EVENT *ev_p)
{
	TW_DATA *TW_data_p;

	/* NOTE: We come here via the E_CREATE for the task window, but we
	 * reset the event handler to the generic handler once the event
	 * vector is set.
	 */

	/* Allocate a TW data object, and then attach it to the TW.
	 */
	if ((TW_data_p = (TW_DATA*)xvt_zmalloc (sizeof (TW_DATA))) == NULL)
		xvt_error ("Cannot allocate browser window data.");

	set_app_data (win, (long)TW_data_p);
	TW_ev_register (TW_data_p);
	set_handler (win, EV_eh);

	win_menu_enable (win, M_FILE_OPEN, TRUE);

	return (0L);
}

/**************************************************************************/
PRIVATE void
TW_ev_register (TW_DATA *TW_data_p)
{
	EV *ev;
	int count = 0;

	ev = EV_create (TW_SIZE_EV);
	TW_data_p->ev = ev;

	EV_set_eh (ev, count++, E_COMMAND, M_FILE_OPEN, TW_command_file_open_eh);
}

/**************************************************************************/
PRIVATE long
TW_command_file_open_eh (WINDOW win, EVENT *ev_p)
{
	BW_new (win);
	return (EV_CONSUMED);
}
