/***************************************************************************

 FILENAME:		hwx_util.c
 DESCRIPTION:   Utility functions source module for DDJ HWX example program.

****************************************************************************
	Copyright 1992 XVT Software Inc. All rights reserved.  XVT is a
	trademark of XVT Software Inc.

			XVT Software Inc., Box 18750, Boulder CO 80308 USA
					(303) 443-4223  fax: (303) 443-0969
***************************************************************************/

#include "xvt.h"
#include "hwx_util.h"

#include "h_config.h"
#include "h_stddef.h"
#include "h_grafic.h"

#include <stdio.h>
#include <alloc.h>

private int x_conversion = 3;
private int y_conversion = 3;

/************************************************************************/
public void gr_move_to (WINDOW win, INT16 h, INT16 v)
{
	PNT pnt;

	pnt.v = v;
	pnt.h = h;

	win_move_to (win, pnt);
}

/************************************************************************/
public void gr_draw_to (WINDOW win, INT16 h, INT16 v)
{
	PNT pnt;

	pnt.v = v;
	pnt.h = h;

	win_draw_line (win, pnt);
}

/************************************************************************/
public void gr_DrawRect (WINDOW win, lpRect r)
{
	RCT rct;
	short saved_width;
	COLOR saved_color;
	DRAW_CTOOLS draw_ctools;

	/* Set the drawing attributes so that the border rectangles are
	 * always BLACK, and of width 1.
	 */
	win_get_draw_ctools (win, &draw_ctools);
	saved_width = draw_ctools.pen.width;
	saved_color = draw_ctools.pen.color;
	draw_ctools.pen.width = (short)1;
	draw_ctools.pen.color = COLOR_BLACK;
	win_set_draw_ctools (win, &draw_ctools);

	rct.top    = r->top;
	rct.left   = r->left;
	rct.bottom = r->bottom;
	rct.right  = r->right;

	win_draw_rect (win, &rct);

	draw_ctools.pen.width = saved_width;
	draw_ctools.pen.color = saved_color;
	win_set_draw_ctools (win, &draw_ctools);
}

/************************************************************************/
public void gr_SetRect(lpRect r,INT16 left,INT16 top,INT16 right,INT16 bottom)
{
	r->left  = left;    r->top    = top;
	r->right = right;   r->bottom = bottom;
}

/************************************************************************/
public void gr_InflateRect(lpRect r,INT16 delta)
{
	r->left   -= delta;    r->top    -= delta;
	r->right  += delta;    r->bottom += delta;
}

/************************************************************************/
public void gr_ShiftRect(lpRect r,INT16 x_delta,INT16 y_delta)
{
	r->left   += x_delta;    r->top    += y_delta;
	r->right  += x_delta;    r->bottom += y_delta;
}

/************************************************************************/
public void gr_ShiftPoint(lpVHPoint p,INT16 x_delta,INT16 y_delta)
{
	p->h  += x_delta;        p->v  += y_delta;
}

/****************************************************************/
public void gr_SetTabToScrConversion(int x, int y)
{
	x_conversion = x;
	y_conversion = y;
}

#define X_TAB2SCR(x)   ((x) >> x_conversion)
#define Y_TAB2SCR(y)   ((y) >> y_conversion)

/***********************************************************************/
public void gr_TabletToScreen(INT16 x,INT16 y,LPINT16 xx,LPINT16 yy)
{
	*xx = X_TAB2SCR(x);
	*yy = Y_TAB2SCR(y);
}
/****************************************************************/
public void gr_CvtTabPtToScreen(lpVHPoint p)
{
	INT16 x,y;
	x = X_TAB2SCR(p->h);
	y = Y_TAB2SCR(p->v);
	p->h = x;
	p->v = y;
}
/****************************************************************/
public void gr_ConvertRectTabletToScreen(lpRect r)
{
	INT16 x1,y1,x2,y2;
	x1 = X_TAB2SCR(r->left);     y1 = Y_TAB2SCR(r->top);
	x2 = X_TAB2SCR(r->right);    y2 = Y_TAB2SCR(r->bottom);
	gr_SetRect(r,x1,y1,x2,y2);
}

/**************************************************************************/
PUBLIC void
UTIL_calc_bbox (WINDOW win, lpList char_instance, lpRect bb)
{
	INT16 i, j;
	INT16 x_min, x_max, y_min, y_max;
	INT16 height, width;

	x_min = y_min = MAX_VALUE;
	x_max = y_max = MIN_VALUE;

	/*------for a given char, find the maximum and minimum -------*/
	for (i = 0; i < char_instance->num_items; i++)
	{
		lpList stroke = char_instance->items[i];

		for (j = 0; j < stroke->num_items; j++)
		{
			VHPoint p = *(lpVHPoint)&stroke->items[j];
			if (p.h > x_max) x_max = p.h;
			if (p.h < x_min) x_min = p.h;
			if (p.v > y_max) y_max = p.v;
			if (p.v < y_min) y_min = p.v;
		}
	}
	bb->left   = x_min;
	bb->top    = y_min;
	bb->right  = x_max;
	bb->bottom = y_max;
}

/**************************************************************************/
PUBLIC void
UTIL_draw_norm_instance (WINDOW win, lpList char_instance, lpRect bbox,
						 INT16 hshift, INT16 vshift)
{
	INT16 i, j;
	INT16 x_min, y_min;

	x_min = bbox->left;
	y_min = bbox->top;

	for (i = 0; i < char_instance->num_items; i++)
	{
		lpList stroke = char_instance->items[i];
		for (j = 0; j < stroke->num_items; j++)
		{
			VHPoint p = *(lpVHPoint)&stroke->items[j];
			p.h -= x_min;
			p.v -= y_min;

			gr_CvtTabPtToScreen (&p);
			gr_ShiftPoint (&p, hshift, vshift);

/*			gr_SetColorYellow(); */

			if (j == 0)
				gr_move_to (win, p.h, p.v);
			else
				gr_draw_to (win, p.h, p.v);
		}
	}
}

