/***************************************************************************

 FILENAME:		hwx_util.h
 DESCRIPTION:   Header for hwx_util.c

****************************************************************************
	Copyright 1992 XVT Software Inc. All rights reserved.  XVT is a
	trademark of XVT Software Inc.

			XVT Software Inc., Box 18750, Boulder CO 80308 USA
					(303) 443-4223  fax: (303) 443-0969
***************************************************************************/

#ifndef HWX_UTIL_H
#define HWX_UTIL_H

#include "xvt.h"
#include "hwx.h"
#include "hwx_glob.h"
#include "hwx_bw.h"

#define MIN_VALUE (-0x7FFF)
#define MAX_VALUE ( 0x7FFF)

/***************************
 DATA STRUCTURE DEFINITIONS
***************************/



/**********************
 FUNCTION DECLARATIONS
**********************/

PUBLIC_FCN void UTIL_calc_bbox (WINDOW, lpList, lpRect);
PUBLIC_FCN void UTIL_draw_norm_instance (WINDOW, lpList, lpRect, INT16, INT16);

public void gr_TabletToScreen(INT16 x,INT16 y,LPINT16 xx,LPINT16 yy);

public void gr_move_to (WINDOW win, INT16 h, INT16 v);
public void gr_draw_to (WINDOW win, INT16 h, INT16 v);

public void gr_ShiftRect(lpRect r,INT16 x_delta,INT16 y_delta);
public void gr_InflateRect(lpRect r,INT16 delta);
public void gr_DrawRect(WINDOW win, lpRect r);

public void gr_CvtTabPtToScreen(lpVHPoint p);
public void gr_ConvertRectTabletToScreen(lpRect r);
public void gr_PutPoint(lpVHPoint p);

public void gr_SetRect(lpRect r,
						   INT16 left,INT16 top,INT16 right,INT16 bottom);
#endif /* HWX_UTIL_H */