//---------------------------------------------------------//
//            Autumn Hill Software Incorporated            //
//        Copyright (c) 1992 -- All Rights Reserved        //
//---------------------------------------------------------//
// File:   HB.CPP                                          //
// Desc:   HWX File Browser                                //
// Date:   July, 1992                                      //
//---------------------------------------------------------//

#include "stdlib.h"
#include "stdio.h"
#include "alloc.h"

#include "hwx.hpp"
#include "mn3.hpp"
#include "m3asm.h"

#include "logo.hpp"    // AHS logo icon

extern unsigned _stklen = 8000;

extern mWindow * printer_dialog( mFont *fnt, char *title,
                                 char *drvrpath, mRect area,
                                 PXLREAD getp, SIGPROC sigp );

mWindow * chview_window( mFont * sysfnt );
mWindow * alview_window( mFont * sysfnt );
mWindow * stview_window( mFont * sysfnt );
mWindow * colors_window( mFont * sysfnt );
mWindow * about_window( mFont * sysfnt );

//---------------------------------------------------------//

// file I/O variables

#define PATHSPECLENGTH 80

char hwxpath[PATHSPECLENGTH],    // file path-spec
     hwxfile[PATHSPECLENGTH];    // qualified filename

// HWX related variables

HwxCharAccessTable *CurHwxTbl;
HwxChar            *CurHwxChar;
HwxChar            *CurHwxStr;
int                 CurHwxStrLen;
char               *CurHwxStrField;
HwxCharSet         *CurHwxCharSet;
HwxAlphabet        *CurHwxAlphabet;

// main window pointer

mWindow *MainWn;

// attributes for character drawing

mPen   hwxpen( 5, 0, 0, 3 );
mBrush hwxbrush( 0 );

// character display related variables

static int  ascii_code = 'A';
static char ascii_code_str[4];

static int  instance = 0;
static char instance_str[4];

static int  scale = 25;
static char scale_str[4];

static int  al_hsb_reading = 0;
static int  al_vsb_reading = 10;

static int  st_hsb_reading = 0;
static int  st_vsb_reading = 10;

static char view_str[41] = "";

//---------------------------------------------------------//

// application menu structures

char *main_labels[] =
{
   " ~F~iles ",
   " ~V~iew ",
   " ~O~ptions "
};

mKey main_keys[] =
{
   mKey( kbOTHER, kbALTF, kbALTKEY ),
   mKey( kbOTHER, kbALTV, kbALTKEY ),
   mKey( kbOTHER, kbALTO, kbALTKEY ),
};

#define NMAIN ( sizeof(main_labels) / sizeof(char *) )

mMenuDef main_menu( main_labels, main_keys, NMAIN, '~' );

char *file_labels[] =
{
   " ~O~pen ",
   " ~A~bout ",
   " ~Q~uit "
};

mKey file_keys[] =
{
   mKey( kbOTHER, kbALTO, kbALTKEY ),
   mKey( kbOTHER, kbALTA, kbALTKEY ),
   mKey( kbOTHER, kbALTQ, kbALTKEY ),
};

#define NFILE ( sizeof(file_labels) / sizeof(char *) )

mMenuDef file_menu( file_labels, file_keys, NFILE, '~' );

char *view_labels[] =
{
   " ~C~haracter ",
   " ~A~lphabet ",
   " ~S~tring "
};

mKey view_keys[] =
{
   mKey( kbOTHER, kbALTC, kbALTKEY ),
   mKey( kbOTHER, kbALTA, kbALTKEY ),
   mKey( kbOTHER, kbALTS, kbALTKEY ),
};

#define NVIEW ( sizeof(view_labels) / sizeof(char *) )

mMenuDef view_menu( view_labels, view_keys, NVIEW, '~' );

char *optn_labels[] =
{
   " ~P~alette ",
   " ~C~olors ",
};

mKey optn_keys[] =
{
   mKey( kbOTHER, kbALTP, kbALTKEY ),
   mKey( kbOTHER, kbALTC, kbALTKEY ),
};

#define NOPTN ( sizeof(optn_labels) / sizeof(char *) )

mMenuDef optn_menu( optn_labels, optn_keys, NOPTN, '~' );

//---------------------------------------------------------//

// signal function for printing

static mWnCtlButton *prtbut;
static mBrush        oldbrush;
static mRect         prtbox;

void signal_prt( int printing )
{
   mWindowManager *wm = prtbut->getwind()->getwnmgr();
   *wm << mMsg( mMOUSE, mHIDECURSOR );
   if( printing )
   {
      oldbrush = prtbut->getnodes()->rgn->getbrush();
      prtbut->getnodes()->rgn->setbrush( mBrush(6) );
      prtbut->draw();
      prtbut->press();
   }
   else
   {
      prtbut->getnodes()->rgn->setbrush( oldbrush );
      prtbut->draw();
   }
   *wm << mMsg( mMOUSE, mSHOWCURSOR );
}

//---------------------------------------------------------//

// get-pixel function for printing

int cdecl gethwxpixel( int x, int y )
{
   int yc = prtbox.ymax + prtbox.ymin - y;
   return mGdMgr::readpixel( mPoint(x,yc) ) == hwxpen.pfg ?
                  0 : 15;
}

//---------------------------------------------------------//

// print task

int print_task( mMsg& msg, mWnControl& ctl )
{
   if( (msg.verb == mEXECUTE) || (msg.verb == mENDEXECUTE) )
   {
      prtbut = (mWnCtlButton *) &ctl;
      mWnControl *apr = ctl.getwind()->getclientctllist();
      mRect r = apr->getnodes()->rgn->interior();
      prtbox = r;
      mWindowManager *wm = ctl.getwind()->getwnmgr();
      *wm <<  * printer_dialog( &wm->systemfont(),
                                "Print HWX Sample",
                                0, r, gethwxpixel,
                                signal_prt );
      return 1;
   }
   return 0;
}

//---------------------------------------------------------//

// function to load a specific character code-instance

int loadhwxchar( int asciicode, int instance )
{
   if( CurHwxChar ) { delete CurHwxChar;  CurHwxChar = 0; }
   CurHwxChar = new HwxChar;
   if( CurHwxChar )
     if( CurHwxTbl->locate( asciicode, instance ) )
        if( CurHwxChar->read( CurHwxTbl->fptr ) > 0 )
           return 1;
   return 0;
}

//---------------------------------------------------------//

// function to load a specific alphabet instance

int loadhwxalphabet( int instance )
{
   if( CurHwxAlphabet )
   {
      delete CurHwxAlphabet;
      CurHwxAlphabet = 0;
   }
   CurHwxAlphabet = new HwxAlphabet( instance,
                                     *CurHwxTbl );
   return CurHwxAlphabet->nchars > 0 ? 1 : 0;
}

//---------------------------------------------------------//

// function to load a specific string instance

int loadhwxstring( int instance, char *str )
{
   if( CurHwxStr )
   {
      delete [] CurHwxStr;
      CurHwxStr = 0;
   }

   CurHwxStrLen = strlen( str );
   if( CurHwxStrLen == 0 ) return 1;
   CurHwxStr = new HwxChar [CurHwxStrLen];
   if( CurHwxStr == 0 ) return 0;

   for( int i=0; i<CurHwxStrLen; i++ )
   {
     if( CurHwxTbl->locate( str[i], instance ) )
        CurHwxStr[i].read( CurHwxTbl->fptr );
   }
   return 1;
}

//---------------------------------------------------------//

// function to draw a character

void drawhwxchar( HwxChar *hc, int ox, int oy, int scl )
{
   int xmin, ymin, xmax, ymax;
   hc->extent( &xmin, &ymin, &xmax, &ymax );
   xmin = iscale( xmin, scl, 100 );
   ymax = iscale( ymax, scl, 100 );
   for( int i=0; i<hc->nstrokes; i++ )
   {
      HwxStroke *stk = &hc->strokes[i];
      int n = 0;
      int x = iscale( stk->xo, scl, 100 ) - xmin;
      int y = ymax - iscale( stk->yo, scl, 100 );
      mPoint p2( x+ox, y+oy );
      for( int j=0; j<stk->nvect; j++ )
      {
         mPoint p1 = p2;
         x = iscale( stk->vect[n++], scl, 100 );
         y = iscale( stk->vect[n++], scl, 100 );
         p2.x += x;
         p2.y -= y;
         mGdMgr::drawline( p1, p2, hwxpen );
      }
   }
}

//---------------------------------------------------------//

// a standard window exit task

int exit_task( mMsg& msg, mWnControl& ctl )
{
   if( (msg.verb == mEXECUTE) || (msg.verb == mENDEXECUTE) )
   {
      mWindowManager *wm = ctl.getwind()->getwnmgr();
      *wm <<  mMsg( mWINDOW, mCLOSE );
      return 1;
   }
   return 0;
}

//---------------------------------------------------------//

// callback for open-file dialog

void open_file( mWindowManager& wm, char *fn )
{
   // did user cancel?
   if( fn[0] == 0 ) return;

   // signal user
   mFont *fnt = &wm.systemfont();
   mRect r = MainWn->getclientrect();
   r >>= 20;
   r.ymin = r.ymax - 35;
   mRgnBorder *rb = new mRgnBorder( r );
   rb->setbrush( mBrush(15) );
   wm << mMsg( mMOUSE, mHIDECURSOR );
   rb->draw();
   fnt->drawstring( r, "Scanning HWX File...." );
   wm << mMsg( mMOUSE, mSHOWCURSOR );

   // scan the file, create access table
   if( CurHwxTbl ) { delete CurHwxTbl;  CurHwxTbl = 0; }
   CurHwxTbl = new HwxCharAccessTable( fn, 128 );

   // get rid of prompt
   wm << mMsg( mMOUSE, mHIDECURSOR );
   delete rb;
   mGdMgr::fillrect( r, DefaultWnClientBrush() );
   wm << mMsg( mMOUSE, mSHOWCURSOR );

   if( (CurHwxTbl == 0) || (CurHwxTbl->status !=atOPEN) )
   {
      beep();
      wm << *notify( fnt, "Error",
                     "File scan failed!" );
   }
   else
   {
      // modify main window's title
      char t[80];
      strcpy( t, "HWX Browser-" );
      strcat( t, fn );
      MainWn->settitle( t );
   }
}

//---------------------------------------------------------//

// ascii-code selector function

char * ascii_code_selector( int verb )
{
   switch( verb )
   {
      case mNEXT :
           ascii_code++;
           if( ascii_code > 126 ) ascii_code = 126;
           break;
      case mPREVIOUS :
           ascii_code--;
           if( ascii_code <  33 ) ascii_code = 33;
           break;
   }
   sprintf( ascii_code_str, "%c", ascii_code );
   return ascii_code_str;
}

// ascii-code view-char task

int asc_ch_task( mMsg& msg, mWnControl& ctl )
{
   if( msg.verb == mTERM )
   {
      loadhwxchar( ascii_code, instance );
      mWnControl *apr = ctl.getwind()->getclientctllist();
      *apr << mMsg( mCONTROL, mDRAW );
   }
   return 0;
}

//---------------------------------------------------------//

// instance selector function

char * instance_selector( int verb )
{
   switch( verb )
   {
      case mNEXT :
           instance++;
           if( instance > 19 ) instance = 19;
           break;
      case mPREVIOUS :
           instance--;
           if( instance <  0 ) instance = 0;
           break;
   }
   sprintf( instance_str, "%d", instance );
   return instance_str;
}

// instance view-char task

int inst_ch_task( mMsg& msg, mWnControl& ctl )
{
   if( msg.verb == mTERM )
   {
      loadhwxchar( ascii_code, instance );
      mWnControl *apr = ctl.getwind()->getclientctllist();
      *apr << mMsg( mCONTROL, mDRAW );
   }
   return 0;
}

// instance view-alphabet task

int inst_al_task( mMsg& msg, mWnControl& ctl )
{
   if( msg.verb == mTERM )
   {
      loadhwxalphabet( instance );
      mWnControl *apr = ctl.getwind()->getclientctllist();
      *apr << mMsg( mCONTROL, mDRAW );
   }
   return 0;
}

// instance view-string task

int inst_st_task( mMsg& msg, mWnControl& ctl )
{
   if( msg.verb == mTERM )
   {
      loadhwxstring( instance, CurHwxStrField );
      mWnControl *apr = ctl.getwind()->getclientctllist();
      *apr << mMsg( mCONTROL, mDRAW );
   }
   return 0;
}

//---------------------------------------------------------//

// scale selector function

char * scale_selector( int verb )
{
   switch( verb )
   {
      case mNEXT :
           scale++;
           if( scale > 100 ) scale = 100;
           break;
      case mPREVIOUS :
           scale--;
           if( scale <  1 ) scale = 1;
           break;
   }
   sprintf( scale_str, "%d", scale );
   return scale_str;
}

// scale view-char task

int scale_ch_task( mMsg& msg, mWnControl& ctl )
{
   if( msg.verb == mTERM )
   {
      mWnControl *apr = ctl.getwind()->getclientctllist();
      *apr << mMsg( mCONTROL, mDRAW );
   }
   return 0;
}

// scale view-alphabet task

int scale_al_task( mMsg& msg, mWnControl& ctl )
{
   if( msg.verb == mTERM )
   {
      mWnControl *apr = ctl.getwind()->getclientctllist();
      *apr << mMsg( mCONTROL, mDRAW );
   }
   return 0;
}

// scale view-string task

int scale_st_task( mMsg& msg, mWnControl& ctl )
{
   if( msg.verb == mTERM )
   {
      mWnControl *apr = ctl.getwind()->getclientctllist();
      *apr << mMsg( mCONTROL, mDRAW );
   }
   return 0;
}

//---------------------------------------------------------//

// task to draw a character

int draw_ch_task( mMsg& msg, mWnControl& ctl )
{
   if( (msg.verb == mENDDRAW) || (msg.verb == mDRAW) )
   {
      mWindowManager *wm = ctl.getwind()->getwnmgr();
      if( CurHwxChar )
      {
         // get character's bounding rect and scale
         mRect r;
         CurHwxChar->extent( &r.xmin, &r.ymin,
                             &r.xmax, &r.ymax );
         r.xmin = iscale( r.xmin, scale, 100 );
         r.ymin = iscale( r.ymin, scale, 100 );
         r.xmax = iscale( r.xmax, scale, 100 );
         r.ymax = iscale( r.ymax, scale, 100 );

         // compute origin to center in aperture
         mRect s = ctl.getnodes()->rgn->interior();
         int dx = s.xmin + ((s.delx()-r.delx()) >> 1);
         int dy = s.ymin + ((s.dely()-r.dely()) >> 1);

         // and draw the character
         *wm << mMsg( mMOUSE, mHIDECURSOR );
         mGdMgr::setcliprect( s );
         mGdMgr::fillrect( s, hwxbrush );
         drawhwxchar( CurHwxChar, dx, dy, scale );
         mGdMgr::setcliprect( );
         *wm << mMsg( mMOUSE, mSHOWCURSOR );
      }
      else
      {
         mRect s = ctl.getnodes()->rgn->interior();
         mFont *fnt = &wm->systemfont();
         *wm << mMsg( mMOUSE, mHIDECURSOR );
         mGdMgr::fillrect( s, hwxbrush );
         fnt->drawstring( s, "Invalid Character Instance" );
         *wm << mMsg( mMOUSE, mSHOWCURSOR );
      }
   }
   return 0;
}

//---------------------------------------------------------//

// task to draw an alphabet

int draw_al_task( mMsg& msg, mWnControl& ctl )
{
   if( (msg.verb == mENDDRAW) || (msg.verb == mDRAW) )
   {
      mWindowManager *wm = ctl.getwind()->getwnmgr();

      // white space between characters
      int whsp = 10;

      // compute scaled dimensions of alphabet
      int adx = 0;
      int ady = 0;
      for( int i=1; i<128; i++ )
      {
         HwxChar *hc = &CurHwxAlphabet->charset[i];
         if( hc->nstrokes == 0 ) continue;
         int x1,y1,x2,y2;
         hc->extent( &x1, &y1, &x2, &y2 );
         x1 = iscale( x1, scale, 100 );
         y1 = iscale( y1, scale, 100 );
         x2 = iscale( x2, scale, 100 );
         y2 = iscale( y2, scale, 100 );
         adx += x2 - x1 + 1 + whsp;
         int ydel = y2 - y1 + 1;
         if( ydel > ady ) ady = ydel;
      }

      // get horz scrollbar control and reading
      mWnCtlHScrollBar *hsb = (mWnCtlHScrollBar *) ctl.next;
      mPoint p = hsb->read();
      al_hsb_reading = p.x;

      // compute leftmost x coordinate;
      int xo = iscale( adx, p.x, p.y );

      // get vert scrollbar control and reading
      mWnCtlVScrollBar *vsb = (mWnCtlVScrollBar *) ctl.next->next;
      p = vsb->read();
      al_vsb_reading = p.x;

      // get aperture interior
      mRect r = ctl.getnodes()->rgn->interior();

      // compute y offset
      int yofs = iscale( r.dely(), p.x, p.y );

      // draw the alphabet
      *wm << mMsg( mMOUSE, mHIDECURSOR );
      mGdMgr::setcliprect( r );
      mGdMgr::fillrect( r, hwxbrush );
      int x = r.xmin - xo;
      int y = r.ymin + yofs;
      for( i=1; i<128; i++ )
      {
         HwxChar *hc = &CurHwxAlphabet->charset[i];
         if( hc->nstrokes == 0 ) continue;
         int x1,y1,x2,y2;
         hc->extent( &x1, &y1, &x2, &y2 );
         x1 = iscale( x1, scale, 100 );
         y1 = iscale( y1, scale, 100 );
         x2 = iscale( x2, scale, 100 );
         y2 = iscale( y2, scale, 100 );
         if( (x+x2-x1) >= r.xmin )
            drawhwxchar( hc, x, y, scale );
         x += x2 - x1 + 1 + whsp;
         if( x > r.xmax ) break;
      }
      mGdMgr::setcliprect( );
      *wm << mMsg( mMOUSE, mSHOWCURSOR );
   }
   return 0;
}

//---------------------------------------------------------//

// task to draw a string

int draw_st_task( mMsg& msg, mWnControl& ctl )
{
   if( (msg.verb == mENDDRAW) || (msg.verb == mDRAW) )
   {
      mWindowManager *wm = ctl.getwind()->getwnmgr();

      // white space between characters
      int whsp = 10;
      int blankdx = iscale( 200, scale, 100 );

      // compute scaled dimensions of string
      int adx = 0;
      int ady = 0;
      for( int i=0; i<CurHwxStrLen; i++ )
      {
         HwxChar *hc = &CurHwxStr[i];
         if( CurHwxStrField[i] == ' ' )
            adx += blankdx;
         if( hc->nstrokes == 0 ) continue;
         int x1,y1,x2,y2;
         hc->extent( &x1, &y1, &x2, &y2 );
         x1 = iscale( x1, scale, 100 );
         y1 = iscale( y1, scale, 100 );
         x2 = iscale( x2, scale, 100 );
         y2 = iscale( y2, scale, 100 );
         adx += x2 - x1 + 1 + whsp;
         int ydel = y2 - y1 + 1;
         if( ydel > ady ) ady = ydel;
      }

      // get horz scrollbar control and reading
      mWnCtlHScrollBar *hsb = (mWnCtlHScrollBar *) ctl.next;
      mPoint p = hsb->read();
      st_hsb_reading = p.x;

      // compute leftmost x coordinate;
      int xo = iscale( adx, p.x, p.y );

      // get vert scrollbar control and reading
      mWnCtlVScrollBar *vsb = (mWnCtlVScrollBar *) ctl.next->next;
      p = vsb->read();
      st_vsb_reading = p.x;

      // get aperture interior
      mRect r = ctl.getnodes()->rgn->interior();

      // compute y offset
      int yofs = iscale( r.dely(), p.x, p.y );

      // draw the string
      *wm << mMsg( mMOUSE, mHIDECURSOR );
      mGdMgr::setcliprect( r );
      mGdMgr::fillrect( r, hwxbrush );
      int x = r.xmin - xo;
      int y = r.ymin + yofs;
      for( i=0; i<CurHwxStrLen; i++ )
      {
         HwxChar *hc = &CurHwxStr[i];
         if( CurHwxStrField[i] == ' ' )
            x += blankdx;
         if( hc->nstrokes == 0 ) continue;
         int x1,y1,x2,y2;
         hc->extent( &x1, &y1, &x2, &y2 );
         x1 = iscale( x1, scale, 100 );
         y1 = iscale( y1, scale, 100 );
         x2 = iscale( x2, scale, 100 );
         y2 = iscale( y2, scale, 100 );
         if( (x+x2-x1) >= r.xmin )
            drawhwxchar( hc, x, y, scale );
         x += x2 - x1 + 1 + whsp;
         if( x > r.xmax ) break;
      }
      mGdMgr::setcliprect( );
      *wm << mMsg( mMOUSE, mSHOWCURSOR );
   }
   return 0;
}

//---------------------------------------------------------//

// task for view-alphabet horz scrollbar

int al_hsb_task( mMsg& msg, mWnControl& ctl )
{
   if( (msg.verb == mENDADJUST) || (msg.verb == mENDSCROLL) )
   {
      mWnControl *apr = ctl.getwind()->getclientctllist();
      *apr << mMsg( mCONTROL, mDRAW );
   }
   return 0;
}

// task for view-alphabet vert scrollbar

int al_vsb_task( mMsg& msg, mWnControl& ctl )
{
   if( (msg.verb == mENDADJUST) || (msg.verb == mENDSCROLL) )
   {
      mWnControl *apr = ctl.getwind()->getclientctllist();
      *apr << mMsg( mCONTROL, mDRAW );
   }
   return 0;
}

//---------------------------------------------------------//

// task for view-string horz scrollbar

int st_hsb_task( mMsg& msg, mWnControl& ctl )
{
   if( (msg.verb == mENDADJUST) || (msg.verb == mENDSCROLL) )
   {
      mWnControl *apr = ctl.getwind()->getclientctllist();
      *apr << mMsg( mCONTROL, mDRAW );
   }
   return 0;
}

// task for view-string vert scrollbar

int st_vsb_task( mMsg& msg, mWnControl& ctl )
{
   if( (msg.verb == mENDADJUST) || (msg.verb == mENDSCROLL) )
   {
      mWnControl *apr = ctl.getwind()->getclientctllist();
      *apr << mMsg( mCONTROL, mDRAW );
   }
   return 0;
}

//---------------------------------------------------------//

// task for view-string input field

int st_fld_task( mMsg& msg, mWnControl& ctl )
{
   mWnCtlField * fi = (mWnCtlField *) &ctl;
   if( (msg.verb == mTERM) && (msg.param[0] == kbENTER) )
   {
      strcpy( view_str, fi->get() );
      loadhwxstring( instance, CurHwxStrField );
      mWnControl *apr = ctl.getwind()->getclientctllist();
      *apr << mMsg( mCONTROL, mDRAW );
   }
   else if( msg.verb == mRESET )
   {
      fi->put( view_str );
      fi->reset();
   }
   return 1;
}

//---------------------------------------------------------//

// file menu task

int file_task( mMsg& msg, mWnControl& ctl )
{
   if( msg.verb == mSELECT )
   {
      mWindowManager *wm = ctl.getwind()->getwnmgr();
      mFont *fnt = &wm->systemfont();
      switch( msg.param[0] )
      {
         case 1 : //........OPEN
         *wm << *create_filebox_window( fnt, "Open HWX File",
                                        hwxpath, hwxfile,
                                        open_file );
         return 1;

         case 2 : //........ABOUT
         *wm << *about_window( fnt );
         return 1;

         case 3 : //........QUIT
         *wm <<  mMsg( mMANAGER, mCLOSE );
         return 1;
      }
   }
   return 0;
}

//---------------------------------------------------------//

// view menu task

int view_task( mMsg& msg, mWnControl& ctl )
{
   if( msg.verb == mSELECT )
   {
      mWindowManager *wm = ctl.getwind()->getwnmgr();
      mFont *fnt = &wm->systemfont();
      // something to view?
      if( hwxfile[0] == 0 )
      {
         beep();
         *wm << *notify( fnt, "Note",
                        "You must first open a file!" );
         return 1;
      }
      switch( msg.param[0] )
      {
         case 1 : //........CHAR
         loadhwxchar( ascii_code, instance );
         *wm << *chview_window( fnt );
         return 1;

         case 2 : //........ALPHABET
         loadhwxalphabet( instance );
         *wm << *alview_window( fnt );
         return 1;

         case 3 : //........STRING
         *wm << *stview_window( fnt );
         return 1;
      }
   }
   return 0;
}

//---------------------------------------------------------//

// optn menu task

int optn_task( mMsg& msg, mWnControl& ctl )
{
   if( msg.verb == mSELECT )
   {
      mWindowManager *wm = ctl.getwind()->getwnmgr();
      mFont *fnt = &wm->systemfont();
      switch( msg.param[0] )
      {
         case 1 : //........PALETTE
         *wm << *create_palette_window( fnt );
         return 1;

         case 2 : //........COLORS
         *wm << *colors_window( fnt );
         return 1;
      }
   }
   return 0;
}

//---------------------------------------------------------//

// create color-select window

static char *clrnum[] =
{
   "0", "1",  "2",  "3",  "4",  "5",  "6",  "7",
   "8", "9", "10", "11", "12", "13", "14", "15",
};
static mRect lcarea, bcarea;

int colors_task( mMsg& msg, mWnControl& ctl )
{
   mWindowManager *wm = ctl.getwind()->getwnmgr();
   *wm << mMsg( mMOUSE, mHIDECURSOR );
   mWnCtlToggleGroup *tg = (mWnCtlToggleGroup *) &ctl;
   int c = tg->getpick() - 1;
   if( ctl.tag == 1 )
   {
      hwxpen.pfg = c;
      mGdMgr::fillrect( lcarea, c );
      mGdMgr::framerect( lcarea, 15, 0 );
   }
   else
   {
      hwxbrush.bfg = c;
      mGdMgr::fillrect( bcarea, c );
      mGdMgr::framerect( bcarea, 15, 0 );
   }
   *wm << mMsg( mMOUSE, mSHOWCURSOR );
   if( msg.verb == mENDDRAW )
   {
      mRect r( 25, 200, 44, 219 );
      for( int i=0; i<16; i++ )
      {
         mGdMgr::fillrect( r, i );
         mGdMgr::drawrect( r, 0 );
         r += mPoint(20,0);
      }
      r.set( 25, 100, 44, 119 );
      for( i=0; i<16; i++ )
      {
         mGdMgr::fillrect( r, i );
         mGdMgr::drawrect( r, 0 );
         r += mPoint(20,0);
      }
   }
   return 0;
}

// line thickness selector function

char thick_str[4];

char * thick_selector( int verb )
{
   switch( verb )
   {
      case mNEXT :
           hwxpen.pxy++;
           if( hwxpen.pxy > 5 ) hwxpen.pxy = 5;
           break;
      case mPREVIOUS :
           hwxpen.pxy--;
           if( hwxpen.pxy < 1 ) hwxpen.pxy = 1;
           break;
   }
   sprintf( thick_str, "%d", hwxpen.pxy );
   return thick_str;
}


mWindow * colors_window( mFont * sysfnt )
{
   mWindow *wn = new mWindow( "Colors", 0, sysfnt,
                              370, 330, wBDRFIXED );
   wn->setstatus( wsMODAL|wsDESTROY, 1 );

   mWnCtlText
   *tx = new mWnCtlText( mPoint(25,255), sysfnt,
                         "Line Color..." );
   lcarea.set( 200, 255, 280, 275 );
   *wn << *tx;
   tx = new mWnCtlText( mPoint(25,155), sysfnt,
                        "Background Color..." );
   *wn << *tx;
   bcarea.set( 200, 155, 280, 175 );

   mWnCtlToggleGroup
   *tg = new mWnCtlToggleGroup( mPoint(25,225), sysfnt, 0,
                                clrnum, 16, 1, 20, 20, 0 );
   tg->setexclusive( 1 );
   tg->setmustpick( 1 );
   tg->setpick( hwxpen.pfg+1 );
   tg->tag = 1;
   tg->settask( colors_task );
   tg->setstatus( xPOSTDRAW, 1 );
   *wn << *tg;

   tg = new mWnCtlToggleGroup( mPoint(25,125), sysfnt, 0,
                               clrnum, 16, 1, 20, 20, 0 );
   tg->setexclusive( 1 );
   tg->setmustpick( 1 );
   tg->setpick( hwxbrush.bfg+1 );
   tg->tag = 2;
   tg->settask( colors_task );
   tg->setstatus( xPOSTDRAW, 1 );
   *wn << *tg;

   mRect r( 85, 30, 135, 60 );
   mWnCtlSpinBut
   *sp = new mWnCtlSpinBut( r, sysfnt, "Line Thk",
                           thick_selector );
   *wn << *sp;

   mWnCtlButton
   *bt = new mWnCtlButton( mRect( 235, 30, 295, 50 ),
                           sysfnt, "Exit" );
   bt->settask( exit_task );
   *wn << *bt;

   return wn;
}

//---------------------------------------------------------//

// create string view window

mWindow * stview_window( mFont * sysfnt )
{
   mWindow *wn = new mWindow( "View String", 0, sysfnt,
                              560, 370, wBDRFIXED );
   wn->setstatus( wsMODAL|wsDESTROY, 1 );

   mRect r( 20, 145, 510, 320 );
   mWnCtlAperture *ap = new mWnCtlAperture( r );
   ap->getnodes()->rgn->setbrush( hwxbrush );
   ap->settask( draw_st_task );
   ap->setstatus( xPOSTDRAW, 1 );
   *wn << *ap;

   r.ymax = r.ymin - 10;
   r.ymin = r.ymax - 20;
   mWnCtlHScrollBar
   *hsb = new mWnCtlHScrollBar( r, butRIGHTRIGHT );
   hsb->settask( st_hsb_task );
   hsb->set( st_hsb_reading );
   *wn << *hsb;

   r.set( 520, 145, 540, 320 );
   mWnCtlVScrollBar
   *vsb = new mWnCtlVScrollBar( r, butDOWNDOWN );
   vsb->settask( st_vsb_task );
   vsb->set( st_vsb_reading );
   *wn << *vsb;

   r.set( 25, 60, 95, 90 );
   mWnCtlSpinBut
   *sp = new mWnCtlSpinBut( r, sysfnt, "Instance",
                           instance_selector );
   sp->settask( inst_st_task );
   *wn << *sp;

   r += mPoint( 146, 0 );
   sp = new mWnCtlSpinBut( r, sysfnt, "Scale (PC)",
                           scale_selector );
   sp->settask( scale_st_task );
   *wn << *sp;

   r += mPoint( 146, 0 );
   mWnCtlButton
   *bt = new mWnCtlButton( r, sysfnt, "Print" );
   bt->settask( print_task );
   *wn << *bt;

   r += mPoint( 146, 0 );
   bt = new mWnCtlButton( r, sysfnt, "Exit" );
   bt->settask( exit_task );
   *wn << *bt;

   r.set( 105, 25, 455, 45 );
   mWnCtlField
   *fi = new mWnCtlField( r, sysfnt, 0, 40 );
   fi->settask( st_fld_task );
   fi->put( view_str );
   CurHwxStrField = fi->get();
   *wn << *fi;

   return wn;
}

//---------------------------------------------------------//

// create alphabet view window

mWindow * alview_window( mFont * sysfnt )
{
   mWindow *wn = new mWindow( "View Alphabet", 0, sysfnt,
                              560, 350, wBDRFIXED );
   wn->setstatus( wsMODAL|wsDESTROY, 1 );

   mRect r( 20, 105, 510, 300 );
   mWnCtlAperture *ap = new mWnCtlAperture( r );
   ap->getnodes()->rgn->setbrush( hwxbrush );
   ap->settask( draw_al_task );
   ap->setstatus( xPOSTDRAW, 1 );
   *wn << *ap;

   r.ymax = r.ymin - 10;
   r.ymin = r.ymax - 20;
   mWnCtlHScrollBar
   *hsb = new mWnCtlHScrollBar( r, butRIGHTRIGHT );
   hsb->settask( al_hsb_task );
   hsb->set( al_hsb_reading );
   *wn << *hsb;

   r.set( 520, 105, 540, 300 );
   mWnCtlVScrollBar
   *vsb = new mWnCtlVScrollBar( r, butDOWNDOWN );
   vsb->settask( al_vsb_task );
   vsb->set( al_vsb_reading );
   *wn << *vsb;

   r.set( 25, 20, 95, 50 );
   mWnCtlSpinBut
   *sp = new mWnCtlSpinBut( r, sysfnt, "Instance",
                           instance_selector );
   sp->settask( inst_al_task );
   *wn << *sp;

   r += mPoint( 146, 0 );
   sp = new mWnCtlSpinBut( r, sysfnt, "Scale (PC)",
                           scale_selector );
   sp->settask( scale_al_task );
   *wn << *sp;

   r += mPoint( 146, 0 );
   mWnCtlButton
   *bt = new mWnCtlButton( r, sysfnt, "Print" );
   bt->settask( print_task );
   *wn << *bt;

   r += mPoint( 146, 0 );
   bt = new mWnCtlButton( r, sysfnt, "Exit" );
   bt->settask( exit_task );
   *wn << *bt;

   return wn;
}

//---------------------------------------------------------//

// create character view window

mWindow * chview_window( mFont * sysfnt )
{
   mWindow *wn = new mWindow( "View Character", 0, sysfnt,
                              530, 330, wBDRFIXED );
   wn->setstatus( wsMODAL|wsDESTROY, 1 );

   mRect r( 25, 25, 280, 280 );
   mWnCtlAperture *ap = new mWnCtlAperture( r );
   ap->getnodes()->rgn->setbrush( hwxbrush );
   ap->settask( draw_ch_task );
   ap->setstatus( xPOSTDRAW, 1 );
   *wn << *ap;

   r.set( 310, 210, 390, 250 );
   mWnCtlSpinBut
   *sp = new mWnCtlSpinBut( r, sysfnt, "ASCII Code",
                            ascii_code_selector );
   sp->settask( asc_ch_task );
   *wn << *sp;

   r -= mPoint( 0, 85 );
   sp = new mWnCtlSpinBut( r, sysfnt, "Instance",
                           instance_selector );
   sp->settask( inst_ch_task );
   *wn << *sp;

   r -= mPoint( 0, 85 );
   sp = new mWnCtlSpinBut( r, sysfnt, "Scale (PC)",
                           scale_selector );
   sp->settask( scale_ch_task );
   *wn << *sp;

   r.set( 425, 125, 490, 150 );
   mWnCtlButton
   *bt = new mWnCtlButton( r, sysfnt, "Print" );
   bt->settask( print_task );
   *wn << *bt;

   r -= mPoint( 0, 85 );
   bt = new mWnCtlButton( r, sysfnt, "Exit" );
   bt->settask( exit_task );
   *wn << *bt;

   return wn;
}

//---------------------------------------------------------//

// create "about" window

mWindow * about_window( mFont * sysfnt )
{
   mWindow *wn = new mWindow( "About HWX Browser", 0,
                              sysfnt, 350, 250, wBDRFIXED );
   wn->setstatus( wsMODAL|wsDESTROY, 1 );

   mWnCtlIcon *logoicon = new mWnCtlIcon( mPoint(20,130),
                                          60, 60, ahs_logo,
                                          rgnFLAT );
   *wn << *logoicon;

   mRect r = mRect( 145, 25, 215, 48 );
   mWnCtlButton
   *bt = new mWnCtlButton( r, sysfnt, "Exit" );
   bt->settask( exit_task );
   *wn << *bt;

   mWnCtlText
   *tx = new mWnCtlText( mPoint(135, 175), sysfnt,
                         "H W X   B r o w s e r" );
   *wn << *tx;
   tx = new mWnCtlText( mPoint(215, 145), sysfnt,
                         "by" );
   *wn << *tx;
   tx = new mWnCtlText( mPoint(125, 115), sysfnt,
                         "Autumn Hill Software, Inc." );
   *wn << *tx;
   tx = new mWnCtlText( mPoint(150, 100), sysfnt,
                         "1145 Ithaca Drive" );
   *wn << *tx;
   tx = new mWnCtlText( mPoint(132, 85), sysfnt,
                         "Boulder, Colorado 80303" );
   *wn << *tx;

   return wn;
}

//---------------------------------------------------------//

// create main application window and its menu system

mWindow * app_window( mFont * sysfnt )
{
   // create main window
   mRect  r = mGdMgr::getdisprect();
   int    w = r.delx() + 1;
   int    h = r.dely() + 1;
   mWindow *wn = new mWindow( "HWX Browser", &main_menu,
                              sysfnt, w, h, wBDRSIZABLE );

   // get window's main menu
   mWnCtlBarMenu *mm = wn->getwnmenu();

   // attach pulldowns
   mWnCtlBoxMenu *
   sm = new mWnCtlBoxMenu( sysfnt, &file_menu );
   sm->settask( file_task );
   mm->setpulldown( sm, 1 );

   sm = new mWnCtlBoxMenu( sysfnt, &view_menu );
   sm->settask( view_task );
   mm->setpulldown( sm, 2 );

   sm = new mWnCtlBoxMenu( sysfnt, &optn_menu );
   sm->settask( optn_task );
   mm->setpulldown( sm, 3 );

   return wn;
}

//---------------------------------------------------------//

// perform app initialization

void init_app( void )
{
   SetDefaultPalette( pSky );
   strcpy( hwxpath, getcurrentdir() );
   strcat( hwxpath, "\\*.DAT" );
   memset( hwxfile, 0, PATHSPECLENGTH );
   CurHwxTbl = 0;
   CurHwxChar = 0;
   CurHwxStr = 0;
   CurHwxStrLen = 0;
   CurHwxCharSet = 0;
   CurHwxAlphabet = 0;
}

//---------------------------------------------------------//

// perform app termination

void term_app( void )
{
}

//---------------------------------------------------------//

int main( int argc, char *argv[] )
{
   init_app();
   mWindowManager *WM = new mWindowManager;
   MainWn = app_window( &WM->systemfont() );
   *WM << *MainWn;
   WM->run();
   term_app();
   delete WM;
   printf( "Availble memory = %ld bytes\n", farcoreleft() );
   return 0;
}
