// ---------- assign.cpp

#ifdef ZTC
#include <iomanip.hpp>
#else
#include <iomanip.h>
#endif
#include "assign.h"
#include "gui.h"

// --------- overloaded >
int AssignmentKey::operator>(Key& key)
{
	AssignmentKey& assgnid = (AssignmentKey&)key;
	if (emplno > assgnid.emplno)
		return 1;
	if (emplno == assgnid.emplno && projno > assgnid.projno)
		return 1;
	return 0;
}

// --------- overloaded ==
int AssignmentKey::operator==(Key& key)
{
	AssignmentKey& assgnid = (AssignmentKey&)key;
	return (emplno == assgnid.emplno &&
		projno == assgnid.projno);
}

// --------- overloaded assignment
Key& AssignmentKey::operator= (Key &key)
{
	if (this != &key)	{
		Key::operator=(key);
		AssignmentKey& assgnid = (AssignmentKey&)key;
		emplno = assgnid.emplno;
		projno = assgnid.projno;
	}
	return *this;
}

// ------- write the key to the index file
void AssignmentKey::Write(fstream& ndx)
{
	emplno.Write(ndx);
	projno.Write(ndx);
}

// ------- read the key from the index file
void AssignmentKey::Read(fstream& ndx)
{
	emplno.Read(ndx);
	projno.Read(ndx);
}

// ------- construct from employee number, project number
Assignment::Assignment(int en, int pn) :
		Persistent(*personnel, ASSIGNMENT), assignment(en, pn)
{
	hours_expended = 0;
	assignment.PrimaryKey();
	assignment.emplno.Relate(EMPLOYEE);
	assignment.projno.Relate(PROJECT);
	LoadObject();
}

Assignment::~Assignment()
{
	SaveObject();
}

// --------- read the persistent assignment object
void Assignment::Read()
{
	int emplno, projno;
	ReadObject(emplno);
	ReadObject(projno);
	assignment.SetEmplNo(emplno);
	assignment.SetProjNo(projno);
	ReadObject(hours_expended);
}

// --------- write the persistent assignment object
void Assignment::Write()
{
	WriteObject(assignment.EmplNo());
	WriteObject(assignment.ProjNo());
	WriteObject(hours_expended);
}

// -------- display an assignment object header
void Assignment::Header()
{
	cout << endl;
	cout << "Empl# Employee        Proj# "
		     "Project         Hours" << endl;
	cout << "----- --------------- ----- "
		     "--------------- -----" << endl;
	cout.flush();
}

// -------- display an assignment object 
void Assignment::Display()
{
	cout <<  "Empl #: "
		  << setw(5)
		  << assignment.EmplNo()
		  << setw(0);
	cout << " Proj #: "
		  << setw(5)
		  << assignment.ProjNo()
		  << setw(0);
	cout << " Hours: "
		  << setw(5)
		  << hours_expended
		  << setw(0)
		  << endl;
	cout.flush();
}

// -------- display an assignment object's details
void Assignment::DetailDisplay()
{
	Employee empl(assignment.EmplNo());
	Project proj(assignment.ProjNo());

	cout << setw(5) << empl.EmplNo();
	cout << setw(0);
	cout << ' ';
	cout.setf(ios::left, ios::adjustfield);
	cout << setw(15) << empl.Name();
	cout.setf(ios::right, ios::adjustfield);
	cout << setw(0);
	cout << ' ';
	cout << setw(5) << proj.ProjNo();
	cout << setw(0);
	cout << ' ';
	cout.setf(ios::left, ios::adjustfield);
	cout << setw(15) << proj.Name();
	cout.setf(ios::right, ios::adjustfield);
	cout << setw(0);
	cout << ' ';
	cout << setw(5) << hours_expended << endl;
	cout << setw(0);
	cout.flush();
}

// --- get an existing assignment object 
Assignment *Assignment::GetExisting()
{
	Assignment *assignment;
	if ((assignment = Get()) != NULL)	{
		if (assignment->ObjectExists())	{
			Header();
			assignment->DetailDisplay();
		}
		else	{
			gui.Error("No such assignment on file");
			delete assignment;
			assignment = NULL;
		}
	}
	return assignment;
}

// --- get an assignment object 
Assignment *Assignment::Get()
{
	Assignment *assignment = NULL;
	Employee *employee = Employee::GetExisting();
	if (employee != NULL)	{
		Project *project = Project::GetExisting();
		if (project != NULL)	{
			assignment = new Assignment(employee->EmplNo(),
						project->ProjNo());
			delete project;
		}
		delete employee;
	}
	return assignment;
}

// -------- assignment object input
void Assignment::Input()
{
	gui.UserInput(hours_expended, "Hours expended");
	if (ObjectExists())
		ChangeObject();
}


