// ------- assign.h

#ifndef ASSIGN_H
#define ASSIGN_H

#include "parody.h"
#include "personel.h"

// =====================================
// AssignmentNo class
// concatenated primary key
// =====================================
class AssignmentKey : public Key	{
	EmployeeNo emplno;
	ProjectNo  projno;
	int operator> (Key &key);
	int operator== (Key &key);
	Key& operator= (Key &key);
	void Write(fstream& ndx);
	void Read(fstream& ndx);
	Key *Make() { return new AssignmentKey(); }
	Bool isNullValue()
		{ return (Bool) (EmplNo() == 0 && ProjNo() == 0); }
	friend class Assignment;
public:
	AssignmentKey(int en = 0, int pn = 0) :
						emplno(en), projno(pn) { /* null */}
	int EmplNo()           { return emplno.EmplNo(); }
	int ProjNo()           { return projno.ProjNo(); }
	void SetEmplNo(int en) { emplno.SetEmplNo(en); }
	void SetProjNo(int pn) { projno.SetProjNo(pn); }
};

// =====================================
// Assignment class
// employee/project assignment
// =====================================
class Assignment : public Persistent	{
	AssignmentKey assignment;
	int hours_expended;
	void Read();
	void Write();
public:
	Assignment(int en = 0, int pn = 0);
	~Assignment();
	int ProjNo()        { return assignment.projno.ProjNo(); }
	int EmplNo()        { return assignment.emplno.EmplNo(); }
	ProjectNo& ProjKey()  { return assignment.projno; }
	EmployeeNo& EmplKey() { return assignment.emplno; }
	int Hours()           { return hours_expended; }
	void SetHours(int hrs);
	void AddHours(int hrs);
	void SetEmplNo(int en) { assignment.SetEmplNo(en); }
	void SetProjNo(int pn) { assignment.SetProjNo(pn); }
	// ----- user interface functions
	void Display();
	void DetailDisplay();
	void Input();
	static Assignment *Get();
	static Assignment *GetExisting();
	static void Header();
};

inline void Assignment::SetHours(int hrs)
{
	hours_expended = hrs;
	ChangeObject();
}
inline void Assignment::AddHours(int hrs)
{
	hours_expended += hrs;
	ChangeObject();
}

#endif

