// ------------- dept.cpp

#ifdef ZTC
#include <iomanip.hpp>
#else
#include <iomanip.h>
#endif
#include "personel.h"
#include "gui.h"

// =====================================
// Department class
// =====================================
Department::Department(int dn) :
				Persistent(*personnel, DEPARTMENT), deptno(dn)
{
	manager.Relate(EMPLOYEE);
	LoadObject();
}

Department::~Department()
{
	SaveObject();
}

// ------- read a persistent department object
void Department::Read()
{
	int dpno;
	ReadObject(dpno);
	deptno.SetDeptNo(dpno);
	ReadObject(name);
	int mgr;
	ReadObject(mgr);
	manager.SetEmplNo(mgr);
}

// ------- write a persistent department object
void Department::Write()
{
	WriteObject(deptno.DeptNo());
	WriteObject(name);
	WriteObject(manager.EmplNo());
}

// --------- display department object header
void Department::Header()
{
	cout << endl;
	cout << "Dept# Department      Mgr#"  << endl;
	cout << "----- --------------- -----" << endl;
	cout.flush();
}

// --------- display department object
void Department::Display()
{
	cout.width(5);
	cout << deptno.DeptNo();
	cout.width(0);
	cout << ' ';
	cout.setf(ios::left, ios::adjustfield);
	cout.width(15);
	cout << name;
	cout.width(0);
	cout.setf(ios::right, ios::adjustfield);
	cout << ' ';
	cout.width(5);
	cout << manager.EmplNo();
	cout.width(0);
	cout << endl;
	cout.flush();
}

// -------- department object assignment
Key& DepartmentNo::operator= (Key &key)
{
	if (this != &key)	{
		Key::operator=(key);
		DepartmentNo& dept = (DepartmentNo&) key;
		deptno = dept.deptno;
	}
	return *this;
}

static Department *This;

static void InputVector()
{
	if (gui.Selection() == 1)
		This->InputName();
	else 
		This->InputManager();
}

// ------- select department data member to change
void Department::SelectChange()
{
	This = this;
	gui.UserMenu( "Change Department",
				  "Name",    InputVector,
				  "Manager", InputVector,
				  (char*) NULL );
}

// -------- read department name from user
void Department::InputName()
{
	gui.UserInput(name, "Name", 25);
	if (ObjectExists())
		TryChange();
}

// -------- read department manager from user
void Department::InputManager()
{
	cout << "Manager:" << endl;
	cout.flush();
	Employee *mgr = Employee::GetExisting();
	if (mgr != NULL)	{
		SetManager(mgr->EmplNo());
		if (ObjectExists())
			TryChange();
		delete mgr;
	}
}

// ------- try to change the department object
void Department::TryChange()
{
	if (!ChangeObject())
		gui.Error("Change disallowed");
}

// -------- department object user input
void Department::Input()
{
	InputName();
	InputManager();
}

// -------- get an existing department object
Department *Department::GetExisting()
{
	Department *department = Get();
	if (department != NULL)	{
		if (department->ObjectExists())	{
			Header();
			department->Display();
		}
		else	{
			gui.Error("No such department on file");
			delete department;
			department = NULL;
		}
	}
	return department;
}

// -------- get a department object
Department *Department::Get()
{
	int deptno;
	Department *department = NULL;
	gui.UserInput(deptno,
		"Enter department number (0 to ignore)");
	if (deptno != 0)
		department = new Department(deptno);
	return department;
}



