// -------------- dept.h

#ifndef DEPARTMENT_H
#define DEPARTMENT_H

#include "parody.h"

// =====================================
// DepartmentNo class
// department number primary key
// =====================================
class DepartmentNo : public Key	{
	int deptno;
	int operator> (Key &key)
		{ return deptno > ((DepartmentNo &) key).deptno; }
	int operator== (Key &key)
		{ return deptno == ((DepartmentNo &) key).deptno; }
	Key& operator= (Key &key);
	void Write(fstream& ndx)
		{ ndx.write((char *) &deptno, sizeof deptno); }
	void Read(fstream& ndx)
		{ ndx.read((char *) &deptno, sizeof deptno); }
	Key *Make() { return new DepartmentNo(); }
	Bool isNullValue() { return (Bool) (deptno == 0); }
public:
	DepartmentNo(int dn = 0) { deptno = dn; }	
	int DeptNo() { return deptno; }
	void SetDeptNo(int dn) { deptno = dn; }
};

#include "employee.h"

// =====================================
// Department class
// =====================================
class Department : public Persistent	{
	DepartmentNo deptno;
	String name;
	EmployeeNo manager;
	void Read();
	void Write();
public:
	Department(int dn = 0);
	~Department();
	String &Name()  { return name; }
	int DeptNo()    { return deptno.DeptNo(); }
	void SetName(String& nm);
	void SetManager(int mgr);
	// ----- user interface functions
	void Display();
	void Input();
	void InputName();
	void InputManager();
	void TryChange();
	void SelectChange();
	static Department *Get();
	static Department *GetExisting();
	static void Header();
};

inline void Department::SetName(String& nm)
{
	name = nm;
	ChangeObject();
}

inline void Department::SetManager(int mgr)
{
	manager.SetEmplNo(mgr);
	ChangeObject();
}

#endif

