// --------------- employee.cpp

#ifdef ZTC
#include <iomanip.hpp>
#else
#include <iomanip.h>
#endif
#include "personel.h"
#include "gui.h"

// =====================================
// Employee class (Handle)
// =====================================
Employee::Employee(int en)
{
	ConstructBody(new EmployeeBody(en));
}

// --------- get an existing employee object
Employee *Employee::GetExisting()
{
	Employee *employee = Get();
	if (employee != NULL)	{
		if (employee->ObjectExists())	{
			Header();
			employee->Display();
		}
		else	{
			gui.Error("No such employee on file");
			delete employee;
			employee = NULL;
		}
	}
	return employee;
}

// --------- get an employee object
Employee *Employee::Get()
{
	int emplno;
	Employee *employee = NULL;
	gui.UserInput(emplno,
		"Enter employee number (0 to ignore)");
	if (emplno != 0)
		employee = new Employee(emplno);
	return employee;
}

// ------ display employee object header
void Employee::Header()
{
	cout << endl;
	cout << "Empl# Employee        Dept#" << endl;
	cout << "----- --------------- -----" << endl;
	cout.flush();
}

// =====================================
// EmployeeBody class
// =====================================

EmployeeBody::EmployeeBody(int en) :
		Persistent(*personnel, EMPLOYEE), emplno(en)
{
	deptno.Relate(DEPARTMENT);
	LoadObject();
}

EmployeeBody::~EmployeeBody()
{
	SaveObject();
}

// ------- employee object assignment
Key& EmployeeNo::operator= (Key &key)
{
	if (this != &key)	{
		Key::operator=(key);
		EmployeeNo& empl = (EmployeeNo&) key;
		emplno = empl.emplno;
	}
	return *this;
}

// ------- read a persistent employee object
void EmployeeBody::Read()
{
	int emno, dpno;
	ReadObject(emno);
	emplno.SetEmplNo(emno);
	ReadObject(name);
	ReadObject(dpno);
	deptno.SetDeptNo(dpno);
}

// ------- write a persistent employee object
void EmployeeBody::Write()
{
	WriteObject(emplno.EmplNo());
	WriteObject(name);
	WriteObject(deptno.DeptNo());
}

// ---------- display an employee object
void EmployeeBody::Display()
{
	cout.width(5);
	cout << emplno.EmplNo();
	cout.width(0);
	cout << ' ';
	cout.setf(ios::left, ios::adjustfield);
	cout.width(15);
	cout << name;
	cout.width(0);
	cout.setf(ios::right, ios::adjustfield);
	cout << ' ';
	cout.width(5);
	cout << deptno.DeptNo() << endl;
	cout.width(0);
	cout.flush();
}

// ----- try to change an employee object
void EmployeeBody::TryChange()
{
	if (!ChangeObject())
		gui.Error("Change disallowed");
}

// ------- input employee name from user
void EmployeeBody::InputName()
{
	gui.UserInput(name, "Name", 25);
	if (ObjectExists())
		TryChange();
}

// ------- input employee department from user
void EmployeeBody::InputDepartment()
{
	int dept;
	gui.UserInput(dept, "Department No");
	deptno.SetDeptNo(dept);
	if (ObjectExists())
		TryChange();
}

// -------- employee input
void EmployeeBody::Input()
{
	InputName();
	InputDepartment();
}

static EmployeeBody *This;

static void InputVector()
{
	if (gui.Selection() == 1)
		This->InputName();
	else 
		This->InputDepartment();
}

// ------- select an employee data member to change
void EmployeeBody::SelectChange()
{
	This = this;
	gui.UserMenu( "Change Employee",
				  "Name",       InputVector,
				  "Department", InputVector,
				  (char*) NULL );
}


