// --------------- employee.h

#ifndef EMPLOYEE_H
#define EMPLOYEE_H

#include "parody.h"
#include "dept.h"

// =====================================
// EmployeeNo class
// primary key
// =====================================
class EmployeeNo : public Key {
	int emplno;
	int operator> (Key &key)
		{ return emplno > ((EmployeeNo &) key).emplno; }
	Key& operator= (Key &key);
	int operator== (Key &key)
		{ return emplno == ((EmployeeNo &) key).emplno; }
	void Write(fstream& ndx)
		{ ndx.write((char *) &emplno, sizeof emplno); }
	void Read(fstream& ndx)
		{ ndx.read((char *) &emplno, sizeof emplno); }
	Key *Make() { return new EmployeeNo(); }
	Bool isNullValue() { return (Bool) (emplno == 0); }
	friend class AssignmentKey;
public:
	EmployeeNo(int en = 0) { emplno = en; }
	int EmplNo() { return emplno; }
	void SetEmplNo(int en) { emplno = en; }
};

// =====================================
// EmployeeBody class
// single-copy body of the employee object
// =====================================
class EmployeeBody : public Persistent	{
	friend class Employee;
	EmployeeNo emplno;
	DepartmentNo deptno;
	String name;
	void Read();
	void Write();
	EmployeeBody(int en);
	~EmployeeBody();
	void Display();
	void Input();
	void InputName();
	void InputDepartment();
	void TryChange();
	friend void InputVector();
	void SelectChange();
};

// =====================================
// Employee class
// multicopy handle of the employee object
// =====================================
class Employee : public Handle	{
	EmployeeBody *emplbody()
		{ return ((EmployeeBody *)body); }
public:
	Employee(int en = 0);
	~Employee() {}

	int EmplNo()      { return emplbody()->emplno.EmplNo(); }
	int DeptNo()      { return emplbody()->deptno.DeptNo(); }
	String &Name()           { return emplbody()->name; }
	EmployeeNo& EmplKey()    { return emplbody()->emplno; }
	DepartmentNo& DeptKey()  { return emplbody()->deptno; }
	void SetName(String& nm);
	void SetDeptNo(int dn);
	// ----- user interface functions
	void Display()         { emplbody()->Display(); }
	void Input()			  { emplbody()->Input(); }
	void InputName()		  { emplbody()->InputName(); }
	void InputDepartment() { emplbody()->InputDepartment(); }
	void TryChange()		  { emplbody()->TryChange(); }
	void SelectChange()	  { emplbody()->SelectChange(); }
	static void Header();
	static Employee *Get();
	static Employee *GetExisting();
};

inline void Employee::SetName(String& nm)
{
	emplbody()->name = nm;
	emplbody()->ChangeObject();
}

inline void Employee::SetDeptNo(int dn)
{
	emplbody()->deptno.SetDeptNo(dn);
	emplbody()->ChangeObject();
}

#endif

