// ------------ gui.h

#ifndef USER_H
#define USER_H

// ============================
// Generic User Interface (GUI)
// ============================

#ifdef ZTC
#include <iostream.hpp>
#else
#include <iostream.h>
#endif
#include <stdarg.h>
#include "parody.h"

// -------- screen dimensions
const int SCREENHEIGHT = 25;
const int SCREENWIDTH  = 80;

// ------- where to display menus
const int menux = (SCREENWIDTH/2-SCREENWIDTH/4);
const int menuy = (SCREENHEIGHT/2-SCREENHEIGHT/4);

const int MAXCOMMANDS = 9;	// maximum menu commands

// ------- function key values
const int UPARROW    = 200;
const int DOWNARROW  = 208;
const int RIGHTARROW = 205;
const int LEFTARROW  = 203;
const int ESC        = 27;

// --------- the Generic User Interface class
class GUI	{
	int selection;
	char putback;
public:
	GUI() { selection = putback = 0; }
	// ---- menu processing
	void UserMenu(char *title, ...);
	int Selection() { return selection; }
	// ---- data field entry
	void UserInput(String& s, char *prompt, int len);
	void UserInput(char& c, char *prompt);
	void UserInput(int& i, char *prompt);
	// ---- standard dialogs
	Bool YesNo(char *question);
	void Error(char *message);
	void AnyKey();
	// ----- screen operations
	void SetCursor(int x, int y);
	void ClearScreen();
	void WriteChar(char c, int x, int y);
	void StatusLine(char *s);
	// ----- keyboard operations
	Bool KBCharWaiting();
	char GetKBChar();
	void PutBack(char c);
};

// ----- menu selection structure
struct MenuSelection {
	char *label;
	void (*menufunction)(void);
};

extern GUI gui;		// the GUI object

#endif



