// ---------- index.cpp

// ====================================
// A program to rebuild the indexes 
// for a PARODY database
// ====================================

#include "stdio.h"
#include "personel.h"	// application-specific header

// =====================================
// Personnel Database
// The Employee, Department, Project, and Assignment
// classes depend on this personnel pointer.
// =====================================
Parody *personnel;

void main()
{
	String dbname("PERSONEL");
	remove(dbname+String(".NDX"));	// delete old index file
	personnel = new Parody(dbname);	// open database
	ObjectHeader objhdr;

	ObjAddr nd = 1;
	// ------- scan Parody nodes
	while (nd < personnel->HighestNode())	{
		// --- read the object header for this node
		personnel->GetObjectHeader(nd, objhdr);
		// --- object relative node# 0 is 1st node of object
		if (objhdr.ndnbr == 0)	{
			// --- tell Parody to rebuild indexes this object
			personnel->RebuildIndexes(nd);
			// ----- rebuild depending on class type
			switch (objhdr.classid)	{
				case EMPLOYEE:
				{
					Employee empl;
					cout << "Empl: ";
					empl.Display();
					break;
				}
				case DEPARTMENT:
				{
					Department dept;
					cout << "Dept: ";
					dept.Display();
					break;
				}
				case PROJECT:
				{
					Project proj;
					cout << "Proj: ";
					proj.Display();
					break;
				}
				case ASSIGNMENT:
				{
					Assignment assgn;
					cout << "Asgn: ";
					assgn.Display();
					break;
				}
				default:
					break;
			}
		}
		nd++;
	}
	delete personnel;
}



