// ------------- key.cpp

#include "parody.h"

// ============================================
// base Key class member functions
// ============================================

Key::Key(NodeNbr fa) : LinkedListEntry(NULL)
{
	fileaddr = fa;
	lowernode = 0;
	relatedclass = -1;
	classid = 0;
	indexno = 0;
	if (Persistent::thispers != NULL)	{
		// --- register the key with the object being built
		object = Persistent::thispers;
		AppendListEntry(&object->keys);
		classid = object->objhdr.classid;
		indexno = object->indexcount++;
	}
}

// ------ overloaded =
Key& Key::operator=(Key& key)
{
	if (this != &key)	{
		fileaddr = key.fileaddr;
		lowernode = key.lowernode;
		indexno = key.indexno;
		classid = key.classid;
		relatedclass = key.relatedclass;
	}
	return *this;
}

// --------- a key declares itself primary
void Key::PrimaryKey()
{
	if (indexno != 0 && Persistent::thispers != NULL)	{
		DeleteListEntry();
		PrependListEntry();
		Key *key = (Key *) NextListEntry();
		while (key != NULL)	{
			if (++(key->indexno) == indexno)
				break;
			key = (Key *)(key->NextListEntry());
		}
		indexno = 0;
		Persistent::thispers->RecordObject();
	}
}

