// ------------- key.h

#ifndef KEY_H
#define KEY_H

#include "parody.h"

// ============================
// Key abstract base class
// ============================
class Key : public LinkedListEntry	{
	NodeNbr fileaddr;	  // object node address -> by this key
	NodeNbr lowernode;  // lower node of keys > this key
	int classid;		  // class id for this key
	int indexno;		  // 0=primary key, > 0=secondary key
	int relatedclass;	  // id of class related by this key
	Persistent *object; // object being indexed
	virtual Key *Make() = 0;
	friend class Btree;
	friend class TNode;
	friend class Persistent;
protected:
	Key(NodeNbr fa = 0);
	virtual ~Key() { /* null */ }
	virtual int operator> (Key& key) = 0;
	virtual int operator== (Key& key) = 0;
	virtual Key& operator=(Key& key);
	virtual void Write(fstream& bfile) = 0;
	virtual void Read(fstream& bfile) = 0;
	virtual Bool isNullValue() = 0;
public:
	void PrimaryKey();
	void Relate(int cid)  { relatedclass = cid; }
	void FindObject()		 { object->FindObject(this); }
	void FirstObject()	 { object->FirstObject(this); }
	void LastObject()		 { object->LastObject(this); }
	void NextObject()		 { object->NextObject(this); }
	void PreviousObject() { object->PreviousObject(this); }
};

#endif


