// ------------------ linklist.cpp

#include "linklist.h"

LinkedListEntry::LinkedListEntry(LinkedListHead *lh) :
									listhead(lh)
{
	prev = next = NULL;
	if (lh != NULL)
		AppendListEntry();
}

// ----- append a list entry to the end of the list
void LinkedListEntry::AppendListEntry(LinkedListHead *lh)
{
	if (lh != NULL)
		listhead = lh;
	if (listhead != NULL)	{
		if (listhead->first == NULL)
			listhead->first = this;
		prev = (LinkedListEntry *) listhead->last;
		if (prev != NULL)
			prev->next = this;
		listhead->last = this;
	}
}

// ----- prepend a list entry to the beginning of the list
void LinkedListEntry::PrependListEntry(LinkedListHead *lh)
{
	if (lh != NULL)
		listhead = lh;
	if (listhead != NULL)	{
		if (listhead->last == NULL)
			listhead->last = this;
		next = (LinkedListEntry *) listhead->first;
		if (next != NULL)
			next->prev = this;
		listhead->first = this;
	}
}

// --- Insert a list entry ahead of a specified (*fe) entry.
void LinkedListEntry::InsertListEntry(void *fe,
												LinkedListHead *lh)
{
	if (lh != NULL)
		listhead = lh;
	LinkedListEntry *ahd = (LinkedListEntry *) fe;
	if (listhead != NULL)	{
		if (ahd == NULL)
			AppendListEntry();
		else 	{
			next = ahd;
			prev = ahd->prev;
			ahd->prev = this;
			if (prev == NULL)
				listhead->first = this;
			else
				prev->next = this;
		}
	}
}

// ---------- delete a list entry
void LinkedListEntry::DeleteListEntry()
{
	if (listhead != NULL)	{
		if (next != NULL)
			next->prev = prev;
		else 
			listhead->last = prev;
		if (prev != NULL)
			prev->next = next;
		else
			listhead->first = next;
		listhead = NULL;
	}
	next = prev = NULL;
}



