// ------------ linklist.h

#ifndef LINKLIST_H
#define LINKLIST_H

#ifdef ZTC
#include <iostream.hpp>
#else
#include <iostream.h>
#endif

#ifndef NULL
#define NULL 0
#endif

class LinkedListEntry;

// ============================
// Linked Listhead
// ============================
class LinkedListHead	{
	friend class LinkedListEntry;
	void *first;
	void *last;
public:
	LinkedListHead() { first = last = NULL; }
	virtual ~LinkedListHead() { /* null */ }
	void *FirstListEntry()    { return first; }
	void *LastListEntry()     { return last; }
};

// ============================
// Linked List Entry
// ============================
class LinkedListEntry	{
	LinkedListEntry *prev;
	LinkedListEntry *next;
protected:
	LinkedListHead *listhead;
	LinkedListEntry(LinkedListHead *lh = NULL);
	virtual ~LinkedListEntry() { DeleteListEntry(); }
public:
	void AppendListEntry(LinkedListHead *lh = NULL);
	void PrependListEntry(LinkedListHead *lh = NULL);
	void InsertListEntry(void *fe, LinkedListHead *lh = NULL);
	void DeleteListEntry();
	void *NextListEntry() { return next; }
	void *PrevListEntry() { return prev; }
};

#endif


