// ------------- node.h

#ifndef NODE_H
#define NODE_H

typedef unsigned NodeNbr;
const int nodelength = 128;
const int nodedatalength = nodelength - sizeof(NodeNbr);
const int fileheadersize = sizeof(NodeNbr) * 2;

// ============================
// Node File Header Record
// ============================
class FileHeader	{
	NodeNbr deletednode;		 // first deleted node
	NodeNbr highestnode;		 // highest assigned node
	NodeNbr origdeletednode; // original first deleted node
	NodeNbr orighighestnode; // original highest assigned node
protected:
	fstream nfile;
	Bool newfile;				 // true if building new node file
public:
    FileHeader(String filename);
	virtual ~FileHeader();
	void SetDeletedNode(NodeNbr node) { deletednode = node; }
	NodeNbr DeletedNode() { return deletednode; }
	void SetHighestNode(NodeNbr node) { highestnode = node; }
	NodeNbr HighestNode() { return highestnode; }
	NodeNbr NewNode();
	fstream& Nfile() { return nfile; }
	void ResetNewFile() { newfile = False; }
};

// ============================
// Node Record
// ============================
class Node	{
	NodeNbr nextnode;
protected:
	FileHeader *owner;
	NodeNbr nodenbr;	// current node number
	Bool nodechanged;	// true if the node changed
	Bool deletenode;	// true if the node is being deleted
public:
	Node(FileHeader *hd = NULL, NodeNbr node = 0);
	virtual ~Node();
	Node& operator=(Node &node);
	void SetNextNode(NodeNbr node)
				{ nextnode = node; MarkNodeChanged(); }
	NodeNbr NextNode()    	{ return nextnode; }
	void SetNodeNbr(NodeNbr node) { nodenbr = node; }
	NodeNbr GetNodeNbr()  	{ return nodenbr; }
	void MarkNodeDeleted()	{ deletenode = True; }
	void MarkNodeChanged() 	{ nodechanged = True; }
	Bool NodeChanged()    	{ return nodechanged; }
	long NodeAddress();
	virtual int NodeHeaderSize() { return sizeof(NodeNbr); }
};

#endif

