// ------------- project.cpp

#ifdef ZTC
#include <iomanip.hpp>
#else
#include <iomanip.h>
#endif
#include "personel.h"
#include "gui.h"

// =====================================
// ProjectNo class
// =====================================

Key& ProjectNo::operator= (Key &key)
{
	if (this != &key)	{
		Key::operator=(key);
		ProjectNo& proj = (ProjectNo&) key;
		projno = proj.projno;
	}
	return *this;
}

// =====================================
// Project class
// =====================================

Project::Project(int prno) :
				Persistent(*personnel, PROJECT), projno(prno)
{
	manager.Relate(EMPLOYEE);
	hours_expended = 0;
	LoadObject();
}

Project::~Project()
{
	SaveObject();
}

// -------- read a persistent project object
void Project::Read()
{
	int prno;
	ReadObject(prno);
	projno.SetProjNo(prno);
	ReadObject(name);
	int mgr;
	ReadObject(mgr);
	manager.SetEmplNo(mgr);
	ReadObject(hours_expended);
}

// -------- write a persistent project object
void Project::Write()
{
	WriteObject(projno.ProjNo());
	WriteObject(name);
	WriteObject(manager.EmplNo());
	WriteObject(hours_expended);
}

// -------- display a project object header
void Project::Header()
{
	cout << endl;
	cout << "Proj# Project         Mgr#  Hours" << endl;
	cout << "----- --------------- ----- -----" << endl;
	cout.flush();
}

// -------- display a project object
void Project::Display()
{
	cout.width(5);
	cout << projno.ProjNo();
	cout.width(0);
	cout << ' ';
	cout.setf(ios::left, ios::adjustfield);
	cout.width(15);
	cout << name;
	cout.setf(ios::right, ios::adjustfield);
	cout.width(0);
	cout << ' ';
	cout.width(5);
	cout << manager.EmplNo();
	cout.width(0);
	cout << ' ';
	cout.width(5);
	cout << hours_expended;
	cout.width(0);
	cout << endl;
	cout.flush();
}

static Project *This;

static void InputVector()
{
	switch (gui.Selection())	{
		case 1:
			This->InputName();
			break;
		case 2:
			This->InputManager();
			break;
		case 3:
			This->InputHours();
			break;
		default:
			break;
	}
}

// ----- select a project data member to change
void Project::SelectChange()
{
	This = this;
	gui.UserMenu( "Change Project",
				  "Name",    InputVector,
				  "Manager", InputVector,
				  "Hours",   InputVector,
				  (char*) NULL );
}

// -------- project object input
void Project::Input()
{
	InputName();
	InputManager();
	InputHours();
}

// ----- get the project number from the user
void Project::InputName()
{
	gui.UserInput(name, "Name", 25);
	if (ObjectExists())
		TryChange();
}

// ----- get the project manager from the user
void Project::InputManager()
{
	cout << "Manager: ";
	cout.flush();
	Employee *employee = Employee::GetExisting();
	if (employee != NULL)	{
		SetManager(employee->EmplNo());
		delete employee;
		if (ObjectExists())
			TryChange();
	}
}

// ----- get the project hours expended from the user
void Project::InputHours()
{
	gui.UserInput(hours_expended, "Hours expended");
	if (ObjectExists())
		TryChange();
}

// ------ try to change the project object
void Project::TryChange()
{
	if (!ChangeObject())
		gui.Error("Change disallowed");
}

// --------- get an existing project object
Project *Project::GetExisting()
{
	Project *project;
	if ((project = Get()) != NULL)	{
		if (project->ObjectExists())	{
			Header();
			project->Display();
		}
		else	{
			gui.Error("No such project on file");
			delete project;
		}
	}
	return project;
}

// --------- get a project object
Project *Project::Get()
{
	int projno;
	Project *project = NULL;
	gui.UserInput(projno,
		"Enter project number (0 to ignore)");
	if (projno != 0)
		project = new Project(projno);
	return project;
}



