// ------------- project.h

#ifndef PROJECT_H
#define PROJECT_H

#include "parody.h"
#include "employee.h"

// =====================================
// ProjectNo class
// primary key
// =====================================
class ProjectNo : public Key	{
	int projno;
	int operator> (Key &key)
		{ return projno > ((ProjectNo &) key).projno; }
	int operator== (Key &key)
		{ return projno == ((ProjectNo &) key).projno; }
	Key& operator= (Key &key);
	void Write(fstream& ndx)
		{ ndx.write((char *) &projno, sizeof projno); }
	void Read(fstream& ndx)
		{ ndx.read((char *) &projno, sizeof projno); }
	Key *Make() { return new ProjectNo(); }
	Bool isNullValue() { return (Bool) (projno == 0); }
	friend class AssignmentKey;
public:
	ProjectNo(int prno = 0) { projno = prno; }	
	int ProjNo() { return projno; }
	void SetProjNo(int prno) { projno = prno; }
};

// =====================================
// Project class
// =====================================
class Project : public Persistent	{
	ProjectNo projno;
	String name;
	EmployeeNo manager;
	int hours_expended;
	void Read();
	void Write();
public:
	Project(int prno = 0);
	~Project();
	String &Name()           { return name; }
	int ProjNo()             { return projno.ProjNo(); }
	int Hours()              { return hours_expended;  }
	void SetName(String& nm);
	void SetManager(int mgr);
	void SetHours(int hrs);
	void AddHours(int hrs);
	// ------- user interface functions
	void Display();
	void Input();
	void InputName();
	void InputManager();
	void InputHours();
	void TryChange();
	void SelectChange();
	static Project *Get();
	static Project *GetExisting();
	static void Header();
};

inline void Project::SetName(String& nm)
{
	name = nm;
	ChangeObject();
}

inline void Project::SetManager(int mgr)
{
	manager.SetEmplNo(mgr);
	ChangeObject();
}

inline void Project::SetHours(int hrs)
{
	hours_expended = hrs;
	ChangeObject();
}

inline void Project::AddHours(int hrs)
{
	hours_expended += hrs;
	ChangeObject();
}

#endif

