// -------- strings.cpp

#include "parody.h"

// ------- put a string into a String
void String::putstr(char *s)
{
	delete sptr;
	length = strlen(s);
	sptr = new char[length+1];
	strcpy(sptr, s);
}

// --- convert from char *
String::String(char *s)
{
	sptr = NULL;
	putstr(s);
}

// ------- copy constructor
String::String(String& s)
{
	sptr = NULL;
	putstr(s.sptr);
}

// -------- construct with a size and fill character
String::String(int len, char fill)
{
	length = len;
	sptr = new char[length+1];
	memset(sptr, fill, length);
	*(sptr+len) = '\0';
}

// -------- assignment
String& String::operator=(String &s)
{
	if (this != &s)
		putstr(s.sptr);
	return *this;
}

// ------- concatenation operator (str1 + str2)
String String::operator+(String &s)
{
	String temp(strlen(s.sptr) + strlen(sptr));
	strcpy(temp.sptr, sptr);
	strcat(temp.sptr, s.sptr);
	return temp;
}

// ------ substring: right len chars
String String::right(int len)
{
	String tmp(sptr + strlen(sptr) - len);
	return tmp;
}

// ------ substring: left len chars
String String::left(int len)
{
	String tmp(len);
	strncpy(tmp.sptr, sptr, len);
	return tmp;
}

// ------ substring: middle len chars starting from where
String String::mid(int len, int where)
{
	String tmp(len);
	if (where < (int) strlen(sptr))
		strncpy(tmp.sptr,sptr+where,len);
	return tmp;
}

// ---- find offset to first instance of specified char
int String::FindChar(unsigned char ch)
{
	char *cp = strchr(sptr, ch);
	if (cp == NULL)
		return -1;
	return (int) (cp - sptr);
}

// ------- stream I/O
ostream& operator<< (ostream& os, String& str)
{
	os << str.sptr;
	return os;
}

istream& operator>> (istream& is, String& str)
{
	*str.sptr = '\0';
	while (*str.sptr == '\0')
		is.getline(str.sptr, str.length+1);
	return is;
}


