;
;	hrtime.asm -	Hi Resolution TIMEr for dos
;

IO_DELAY_NEEDED	equ	0	; doesn't seem to need recovery time here
PRVT_TICKS_USED	equ	1	; if a private tick count is to be used
IRET_IF_RESTORE	equ	0	; if the interrupt flag is to be restored 
				; with an IRET, or with the windows suggested
				; method
NONSTANDARD_PIT equ     1       ; Timer has anomalous behavior regarding 
                                ; count/out synchronization
HANDLE_MODE_2   equ     1       ; detects and handles if timer is in other mode
USE_VTD         equ     1       ; detects and uses VTD if in Windows enhanced mode
;
;       WARNING:  Currently, this option does more harm than good.  Use at
;               your own risk.
;
TAG_CRITICAL    equ     0       ; Tag the timer sampling process as critical
;
;       WARNING:  The following switch is a sledgehammer of a fix.  It checks
;               hrtime return values against previous ones given.  If it is
;               about to return a value that appears to be before a previous
;               value, it will simply return the previous value.  This 
;               usually works for conditioning values that are within 55 mS 
;               of previous samples, but can cause undetected errors of up 
;               to 55 mS in samples over any interval.  Though these errors 
;               are rare (they have a small impact when used in averages), 
;               they can have a significant impact in standard deviation or 
;               timing critical applications.  In other words, don't turn 
;               this switch on for that hypothetical pacemaker project.
;
;               This should currently be required only when running in a DOS 
;               box (even when allowing the VTD to calculate high resolution 
;               timing.  Otherwise time values never decrement, and an 
;               apparent negative time delta in fact corresponds to a time 
;               relatively far into the future (16 hours in the default 
;               implementation).
;
LAST_COMPARE    equ     1       ; partially compensates for jittery platforms

;
;	io_delay -	delay just a bit
io_delay	macro
if IO_DELAY_NEEDED
        out     0EDh, al
endif	; IO_DELAY_NEEDED
endm

PIC0_ADDR	equ	020h	; I/O address of PIC 0
TIMER0		equ	040h	; I/O address of Timer 0 
TIMER_STAT	equ	043h	; I/O address for status/control of timers 0-2

PIC_RIRR	equ	00Ah	; Read Interrupt Request Register of a PIC
T0_R_S_C	equ	0C2h	; Timer 0 Read Status and Count

DOS_GLOBALS	equ	040h	; segment for 40:xx variables
SYS_TIMER_CNT	equ	06Ch	; offset for system count

.model	large

.code

assume	ds:nothing, es:nothing

if USE_VTD
vtd_entry       dd      0
endif   ; USE_VTD

if LAST_COMPARE
last_hrtime     dd      0
endif   ; LAST_COMPARE


if PRVT_TICKS_USED
hrt_ticks	dd	0
old_int8	dd	0

;
;	hrt_isr -	the interrupt service routine for private tick 
;			counting for the hi-res timer
;
	public	hrt_isr
hrt_isr	        proc	far

	add	word ptr cs:[hrt_ticks], 1
	adc	word ptr cs:[hrt_ticks+2], 0

	jmp	dword ptr cs:[old_int8]

hrt_isr	        endp
endif	; PRVT_TICKS_USED

;
;	hrt_open -	the init function for the hi-res timer
;
	public	_hrt_open
_hrt_open	proc	far

	push	ds		; save this stuff to avoid bad crashes
	push	es		; save this stuff just to be paranoid
	push	bx
	push	cx
	push	dx
        push    di

if USE_VTD
        xor     ax, ax          ; zero out vtd_entry to prevent spurious calls
        mov     word ptr cs:[vtd_entry], ax
        mov     word ptr cs:[vtd_entry+2], ax

        mov     ax, 01600h      ; windows enhanced installation check
        int     02Fh
        cmp     al, 000h        ; 0=>no win
        je      short hro_no_vtd
        cmp     al, 001h        ; 1=>win/386
        je      short hro_no_vtd
        cmp     al, 080h        ; 80h=>no win
        je      short hro_no_vtd
        cmp     al, 0FFh        ; FFh=>win/386
        je      short hro_no_vtd
hro_is_win3x:
        mov     ax, 01684h      ; Get device API entry point call
        mov     bx, 00005h      ; timer VxD ID
        xor     di, di          ; zero out for API entry point fetch
        mov     es, di
        int     02Fh
        mov     word ptr cs:[vtd_entry], di
        mov     di, es
        mov     word ptr cs:[vtd_entry+2], di
        jmp     short hro_installed     ; we've found the vtd, we need no ISR
endif   ; USE_VTD

hro_no_vtd:
if PRVT_TICKS_USED
	xor	ax, ax
	mov	word ptr cs:[hrt_ticks], ax
	mov	word ptr cs:[hrt_ticks+2], ax

	mov	ax, 03508h	; get int vector for int8 (irq0)
	int	21h

	mov	word ptr cs:[old_int8], bx
	mov	ax, es
	mov	word ptr cs:[old_int8+2], ax

	mov	dx, seg hrt_isr
	mov	ds, dx
	mov	dx, offset hrt_isr
	mov	ax, 02508h	; set int vector for int8 (irq0)
	int	21h
endif	; PRVT_TICKS_USED

hro_installed:
if LAST_COMPARE
        call    far ptr hrt_core
        mov     word ptr cs:[last_hrtime], ax
        mov     word ptr cs:[last_hrtime+2], dx
endif   ; LAST_COMPARE

hro_done:
        pop     di
	pop	dx
	pop	cx
	pop	bx
	pop	es
	pop	ds

	xor	ax, ax

	ret

_hrt_open	endp

;
;	hrt_close -	the un-init function for the hi-res timer
;
	public	_hrt_close
_hrt_close	proc	far

	push	ds		; save this stuff to avoid bad crashes
	push	es		; save this stuff just to be paranoid
	push	bx
	push	cx
	push	dx

if USE_VTD
        xor     ax, ax          ; zero out vtd_entry to prevent spurious calls
        mov     word ptr cs:[vtd_entry], ax
        mov     word ptr cs:[vtd_entry+2], ax
endif   ; USE_VTD

if PRVT_TICKS_USED
	mov	ax, word ptr cs:[old_int8+2]
	mov	ds, ax
	mov	dx, word ptr cs:[old_int8]

        or      ax, dx          ; check if really installed
        jz      short hrc_uinst_done

	mov	ax, 02508h	; set int vector for int8 (irq0)
	int	21h
hrc_uinst_done:
endif	; PRVT_TICKS_USED
	pop	dx
	pop	cx
	pop	bx
	pop	es
	pop	ds

	xor	ax, ax

	ret

_hrt_close	endp

;
;       Whether _hrtime is declared immediately below or further down, it
;       will be public, as it is the defined interface.
;
	public	_hrtime
;
;	HRT_CORE -	the hi-res time reader core code.
;               If LAST_COMPARE is not set, it is directly the _hrtime call.
;               Otherwise it is called by that _hrtime and does only the core
;               calculation to be conditioned by _hrtime with previous value
;               compare.
;
if LAST_COMPARE
hrt_core        proc    far
else    ; LAST_COMPARE
_hrtime	        proc	far
endif   ; LAST_COMPARE
if IRET_IF_RESTORE
	pop	bx		; return ip - to make iret return frame
	pop	ax		; return cs
	pushf			; flags
	push	ax		; cs
	push	bx		; ip
else	; IRET_IF_RESTORE
	pushf			; store flags on stack to check at end
endif	; IRET_IF_RESTORE

if TAG_CRITICAL
        mov     ax, 01681h      ; Hopefully telling Windows this is critical
                                ; will fix the PIC/interrupt synchronization
        int     02Fh            ; int 2F, 1681 - begin critical section
endif   ; TAG_CRITICAL

if USE_VTD
        mov     ax, word ptr cs:[vtd_entry]
        or      ax, word ptr cs:[vtd_entry+2]
        jz      short hrt_no_vtd
        mov     ax, 00100h
        call    dword ptr cs:[vtd_entry]
.386
        ror     eax, 16         ; get bits 16..31 into dx
        mov     dx, ax
        ror     eax, 16         ; restore bits 0..15 to ax
.8086
        jmp     short hrt_done
endif   ; USE_VTD

hrt_no_vtd:
	cli				; freeze ticker while checking
hrt_readhw:
	mov	al, T0_R_S_C		; timer 0 read stat and count
	out	TIMER_STAT, al
	io_delay
	in	al, TIMER0		; store stat in ch
	mov	ch, al
	io_delay
	in	al, TIMER0		; store count in bx
	mov	bl, al
	io_delay
	in	al, TIMER0
	mov	bh, al

	io_delay			; delay between timer and pic access

	mov	al, PIC_RIRR
	out	PIC0_ADDR, al
	io_delay
	in	al, PIC0_ADDR

	test	al, 001h		; check if system time is stale
	jz	short hrt_timegood
	mov	ax, 0ffffh		; force max in lower part
	jmp	short hrt_gotlo
hrt_timegood:
	test	ch, 040h
	jnz	short hrt_readhw	; timer invalid, retry

	mov	ax, bx			; move count to more convenient reg
if NONSTANDARD_PIT
        cmp     ax, 002h                ; timer<=2 => incorrect output bit on
                                        ; some platforms, be safe and lose it
        jbe     short hrt_readhw	; timer invalid, retry
endif   ; NONSTANDARD_PIT
	neg	ax			; convert to count up
if HANDLE_MODE_2
        mov     cl, ch                  ; copy status word for destructive test
        and     cl, 00Eh                ; filter out mode bits
        cmp     cl, 006h                ; check for mode 3 (square wave)
        jne     short hrt_gotlo         ; only mode 3 needs extra work
endif   ; HANDLE_MODE_2
	shl	ch, 1			; bash ch to get high bit of status
					; (output state) into high bit of 
					; count via carry
	cmc				; invert carry to match count negation
	rcr	ax, 1			; mode 3 counts down twice by twos, 
					; first with output high, then low
hrt_gotlo:
;
;	This would be the place to shift ax down if less resolution
;	but greater range were needed.  The merging with system ticks
;	or parallel ticks would have to involve the same shifting.
;
if PRVT_TICKS_USED	; if a parallel tick count is to be used
	mov	dx, word ptr cs:[hrt_ticks]
else	; PRVT_TICKS_USED
	mov	dx, DOS_GLOBALS
	mov	es, dx
	mov	dx, es:[SYS_TIMER_CNT]	; add system time
endif	; PRVT_TICKS_USED

hrt_done:

if TAG_CRITICAL
        mov     ax, 01682h      ; 
                                ; 
        int     02Fh            ; int 2F, 1682 - end critical section
endif   ; TAG_CRITICAL

if IRET_IF_RESTORE
	iret
else	; IRET_IF_RESTORE
	pop	bx			; get flags down to restore interrupt flag
	test	bx, 0200h		; was IF set? (jump if no)
	jz	short hrt_if_done
	sti				; restore interrupts to ON
hrt_if_done:
	ret
endif	; IRET_IF_RESTORE

if LAST_COMPARE
hrt_core        endp
else    ; LAST_COMPARE
_hrtime	        endp
endif   ; LAST_COMPARE

if LAST_COMPARE
;
;       _hrtime - Wrapper for HRT_CORE to allow for conditioning of values.
;
_hrtime         proc	far

        call    hrt_core
        mov     bx, ax
        mov     cx, dx
;
;       thirty two bit compare, (new-old) < 80000000h
;
        sub     bx, word ptr cs:[last_hrtime]
        sbb     cx, word ptr cs:[last_hrtime+2]
        jns     short hrt_new_max

        mov     ax, word ptr cs:[last_hrtime]
        mov     dx, word ptr cs:[last_hrtime+2]
;
;       could fall through here, but I hate unnecessary data access
;
        jmp     short hrt_got_max

hrt_new_max:
        mov     word ptr cs:[last_hrtime], ax
        mov     word ptr cs:[last_hrtime+2], dx

hrt_got_max:
        ret

_hrtime         endp
endif   ; LAST_COMPARE



end
