/****************************************************************
| H_MEM.C  -- memory allocation module
+----------------------------------------------------------------
| The purpose of this is to provide a layer between the application
| and the memory allocation routines in the environment.
| The original Macintosh code did not use this layer, but called
| the standard library directly. In order to facilitate the
| move to MS-Windows, this layer was added.
|
+****************************************************************/

#include "h_config.h"
#include "h_stddef.h"

#ifdef TURBO_C
#include <stdio.h>
#include <alloc.h>
#define HEAP_CHECK heapcheck
#endif
#ifdef MSOFT_C7
#include <stdio.h>
#include <malloc.h>
#define HEAP_CHECK _heapchk
#include <process.h>
#endif

#ifdef INTEL_C32
#include <stdio.h>
#include <malloc.h>
#include <process.h>
#endif

#ifdef LIGHTSPEED_C
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#endif

/****************************************************************/
private long num_operations = 0;
private long bytes_allocd = 0;

public void mem_CheckHeap(void)
{
#ifdef MS_DOS
#ifdef MSOFT_C7_MEM_DBG
    if(HEAP_CHECK() != _HEAPOK)
    {
	fprintf(stderr,"\n***HEAP CHECK FAILED!****");
    }
#endif
#endif
}

/****************************************************************/
public void *mem_Realloc(void *v,size_t num_bytes)
{
#ifdef MS_DOS
#ifdef MSOFT_C7_MEM_DBG
    size_t n = _msize(v);
    bytes_allocd -= n;
#endif
    num_operations++;
    return realloc(v,num_bytes);
#endif
#ifdef LIGHTSPEED_C
    num_operations++;
    return realloc(v,num_bytes);
#endif
}
/****************************************************************/
public void mem_Free(void *v)
{
#ifdef MS_DOS
#ifdef MSOFT_C7_MEM_DBG
    size_t n = _msize(v);
    bytes_allocd -= n;
#endif
    num_operations++;
    free(v);  /*free it anyway*/
#endif
#ifdef LIGHTSPEED_C
	num_operations++;
	free(v);
#endif
}
/****************************************************************/
public void * mem_Alloc(size_t num_bytes)
{
#ifdef MS_DOS
    void *v = malloc(num_bytes);
    bytes_allocd += num_bytes;
    num_operations++;
    return v;
#endif
#ifdef LIGHTSPEED_C
    void *v = malloc(num_bytes);
    bytes_allocd += num_bytes;
    num_operations++;
    return v;	
#endif
}
/****************************************************************/
public void * mem_CAlloc(size_t num_items, size_t item_size)
{
#ifdef MS_DOS
    void *v = calloc(num_items, item_size);
    long num_bytes = (long)(num_items * item_size);
    bytes_allocd += num_bytes;
    num_operations++;
    return v;
#endif
#ifdef LIGHTSPEED_C
    void *v = calloc(num_items, item_size);
    long num_bytes = (long)(num_items * item_size);
    bytes_allocd += num_bytes;
    num_operations++;
    return v;
#endif
}

/****************************************************************/
public void mem_AllocFailed(size_t num_bytes)
{
#ifdef MS_DOS
    fprintf(stderr,"\n***Mem alloc #%ld failed on %ld bytes***",
		(long)num_operations,(long)num_bytes);
    exit(0);
#endif
#ifdef LIGHTSPEED_C
    myBreak("AllocFailed");
    fprintf(stderr,"\n***Mem alloc #%ld failed on %ld bytes (Tot=%ld)***",
		(long)num_operations,(long)num_bytes,(long)bytes_allocd);
    exit(0);
#endif
}
/****************************************************END*********/

