 Area: `Dr. Debug Conference'	Date: 14 Jul 92  02:21:24
  From: Aaron West		To: All
  Subj: makeuue.c

Here's the program that converts any file smaller than 64K to self-decoding
UUE-like form:
-!!!!!!!!!!- makeuue.c
/* c:\pc\makeuue.c */
 
/*
 * Converts a file to a UUE-like form.
 !@#$
 call c makeuue
 $#@!
 
A UUE file has 'M' followed by 64 base 64 digits, encoded as 96=0,
33-95=1-63. The file output by this program will not have the M at the
start of each line, or the 8 at the start of the last line, or the
header line.  It will also have 4*(infile_length+2)/3 UUE characters,
meaning that a conversion back may increase file size by 1 or 2, to
adjust to the next higher multiple of three.
 
Given:
7654321.7654321.7654321.
54321.54321.54321.54321.
c1=byte1, c2=byte2, c3=byte3:
o1=c1>>2; o2=(c1&3)<<4+c2>>4; o3=(c2&15)<<2+c3>>6; o4=c3&63;
62
44
26
08
 */
 
char usage[]="syntax: MAKEUUE filename.in [outfile[.ext]] (default .BAT)\n\r\
\tCreates a batch file that will regenerate filename.in\r\n";
 
#include <stdio.h>
 
/* Desmet C definition: */
#ifndef SEEK_SET
#define strchr(str,c) index(str,c)
#define READ_MODE 0
#define S_IREAD 0
#define S_IWRITE 0
#else
/* for Turbo C */
#include <fcntl.h>
#include <io.h>
#include <sys/stat.h>
int _fmode = O_BINARY;
#define READ_MODE O_RDONLY|O_BINARY
#endif
 
/* self-uudecode script */
char outhead[][60]={
    "debug <", /* room for outfname */
    "\r\nset in=", /* room for infname */
    "\r\ndel %in%\r\nren temp.bin %in%\r\nset in=\r\n",
    "goto end\r\nntemp.bin\r\n",
    "e90 BE 00 01 8B FE 8B D6 33 DB B9 00 FE B4 3F CD 21\r\n",
    "ea0 50 8B C8 B0 7E F2 AE B8 0D 0A AF 75 F4 87 F7 B1\r\n",
    "eb0 02 AD 3D 0D 0A 74 FA 2D 20 20 3C 5A 73 17 24 3F\r\n",
    "ec0 D2 E4 D3 C0 AA 92 AD 2D 20 20 D2 E4 D3 C8 24 0F\r\n",
    "ed0 02 C6 AB EB DC 58 F7 D8 99 92 91 33 DB B8 01 42\r\n",
    "ee0 CD 21 8B CF FE CD CC\r\nrip\r\n90\r\ng\r\nW\r\nQ\r\n~\r\n",
    ""
},(*oh)[60];
 
void out6();
void flush6();
 
union
{
    unsigned int w;
    struct {unsigned char l,h;} c;
} wc;
 
#define BUFFERLEN 16384
unsigned buflen=(BUFFERLEN/3-1)*3;
 
static char outbuf[70],*outb=outbuf;
int outbuflen=64;
int infp,outfp;
char infname[60],outfname[60];
char buf[BUFFERLEN];
 
main(argc,argv)
int argc; char *argv[];
{
    int i,bytesread,bytestoconvert,lshift;
    char *p;
 
    strcpy(infname,argv[1]);
    if (argc==3) strcpy(outfname,argv[2]);
    else /*if (argc==2)*/ {
        strcpy(outfname,infname);
        if ((p=(char *)strchr(outfname,'.'))!=NULL)
          *p='\0';
    }
    if (strchr(outfname,'.')==NULL)
        strcat(outfname,".BAT");
    if (argc<2 || argc>3 ||
      (infp=open(infname,READ_MODE))<0 ||
      (outfp=creat(outfname,S_IREAD|S_IWRITE))<0)
    {
      puts(usage);
      exit(1);
    }
 
    /* write self-uudecode header */
    strcat(outhead[0],outfname);
    strcat(outhead[1],infname);
    for (oh=outhead;*oh!='\0';oh++)
        write(outfp,outhead[i],strlen(outhead[i]));
 
    /* start of conversion */
 
    lshift=6; /* 6,4,2,0 */
    wc.w=0;
    do {
        bytesread=read(infp,buf,buflen);
        *(int*)(buf+buflen)=0; /* 0 terminator for non-multiple of 3 */
        bytestoconvert=(bytesread+2)/3*3;
        
        for (i=0;i<bytestoconvert;i++)
        {
            wc.c.l=buf[i]; /* get 8 bits */
            wc.w<<=lshift; /* get 6,4 or 2 bits */
            out6(wc.c.h);
            wc.c.h=buf[i]; /*(wc.c.l>>lshift);*/ /* save remaining bits for
next time */
            if (!(lshift-=2)) {
                out6(wc.c.h);
                lshift=6;
            }
        }
    } while (bytesread==buflen);
 
    *((int*)outb)=0x7e7e; /* terminator ~~*/
    *((int*)&outb[2])=0x7e7e; /* terminator ~~*/
    outb+=4;
    flush6();
    write(outfp,":end\r\n",6);
 
    close(infp);
    close(outfp);
    return 0;
}
 
void out6(c)
int c;
{
    *outb++=((c-1)&63)+33;
    if (outb-outbuf>=outbuflen)
        flush6();
}
 
void flush6()
{
    if (outb>outbuf)
    {
        *((int *)outb)++=0x0a0d;
        if ((write(outfp,outbuf,outb-outbuf))<outb-outbuf) {
            puts("Error writing!");
            close(outfp);
            close(infp);
            unlink(outfname);  /* clean up */
           
        outb=outbuf;
    }
}
 

-!- Maximus 2.00
 ! Origin: Hartford Metro Area BBS (1:142/911)
