/*  This is file SSWITCH.C  */
/*
**  Copyright (C) 1991 Jun 8  xDrie`sl`mj
**  ̃t@C̎舵GNU GPLɏ]B
**
**  ̃t@CPC9801V[Y̗eLXgʂg
**  sʂƃfobOʂ𕪗邽߂̃R[hłB
**
*/

#include <stdio.h>
#include <dos.h>
#include <mem.h>
#include "types.h"
#include "pc9800.h"

extern	word16 text_seg;	/*  ʃZOgAhX@*/

CRT	user_screen_info;	/*@tsʁ@*/
CRT	debug_screen_info;	/*@cʁ@@*/

static	SEP_TEXT separate_screen[2] = { 0x1000,24,0x0f00,1};

/*@hnDrxrʐ䃏[N@*/
extern	word16	far *active_screen;	/*  0060:0032H  */
extern	CONSOLE	far *console;		/*  0060:0110H  */

/*@ʐ؂ւ֐@*/
static int	switch_screen(CRT *set,CRT *store)
{
  if (*active_screen == set->top_segment)
    return 1;			/*  ؂ւKv͂Ȃ@*/
  *active_screen = set->top_segment;

  movedata(FP_SEG(console),FP_OFF(console),_DS,(word16)&(store->console),15);
	   			/*@ʏޔ@*/
  movedata(_DS,(word16)&(set->console),FP_SEG(console),FP_OFF(console),15);
	   			/*@ʏݒ肷@*/

  _DX = set->top_offset + console->x_pos * 2 + console->y_pos * 160;
  _AH = CURSOR_SET;
  geninterrupt(CONSOLE_BIOS);	/*@J[\ʒuύX@*/

  _AH = (console->cursor_sw)? CURSOR_ON:CURSOR_OFF;
  geninterrupt(CONSOLE_BIOS);
  return 0;
}

/*  tʕ\֐@*/
void	display_user_screen(void)
{
  _DX = user_screen_info.top_offset;
  _AH = SET_TEXT_ADR;
  geninterrupt(CONSOLE_BIOS);	/*@ʕ𔺂Ȃtʁ@*/
}

/*@cʕ\֐@*/
void	display_debug_screen(void)
{
  _BX = _DS;
  _CX = (word16)&separate_screen;
  _DX = 0x0002;
  _AH = SET_SEP_TEXT_ADR;
  geninterrupt(CONSOLE_BIOS);
}

/*@cʐ؂ւ@*/
void	debug_screen(void)
{
  if (switch_screen(&debug_screen_info,&user_screen_info))
    return;
  display_debug_screen();
}

/*@tʐ؂ւ@*/
void	user_screen(int display)
{
  (void)switch_screen(&user_screen_info,&debug_screen_info);
  if (display == ON)
    display_user_screen();
}

/*@ʂ̕@*/
static void	screen_copy(CRT *src,CRT *dest)
{
  movedata(src->top_segment ,0,dest->top_segment ,0,160*25);
  movedata(src->top_atribute,0,dest->top_atribute,0,160*25);
  movmem(&(src->console),&(dest->console),15);
}

/*@cʂ̏@*/
void	screen_initialize(void)
{
  user_screen_info.top_segment   = text_seg;
  user_screen_info.top_atribute  = text_seg + 0x0200;
  user_screen_info.top_offset    = 0;		/*  \sʁ@*/
  debug_screen_info.top_segment  = text_seg + 0x0100;
  debug_screen_info.top_atribute = text_seg + 0x0300;
  debug_screen_info.top_offset   = 0x1000;	/*@sʁ@*/

  movedata(FP_SEG(console),FP_OFF(console),
	   _DS,(word16)&(user_screen_info.console),15);
  screen_copy(&user_screen_info,&debug_screen_info);
  debug_screen();
}

/*@ʂ̏I@*/
void	screen_terminate(void)
{
  movmem(&user_screen_info,&debug_screen_info,sizeof(CRT));
  if (*active_screen != text_seg)
    user_screen(ON);			/*  ʂtʂɖ߂@*/
}

/*@ʕ\֐@*/
int	printf(const char *fmt, ...)
{
  char buf[200];
  int  n;

  debug_screen();
  n = vsprintf(buf, fmt, &...);
  write(1, buf, strlen(buf));
  return n;
}

void	mputchar(char c)
{
  debug_screen();
  write(1, &c, 1);
}

