; This is file TABLES.ASM
;
; Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
;
; This file is distributed under the terms listed in the document
; "copying.dj", available from DJ Delorie at the address above.
; A copy of "copying.dj" should accompany this file; if not, a copy
; should be available from where this file was obtained.  This file
; may not be distributed without a verbatim copy of "copying.dj".
;
; This file is distributed WITHOUT ANY WARRANTY; without even the implied
; warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;

;  Modified for PC9801 Series by Y.Shibata  May 6th 1991

;	History:20,1
	title	tables
	.386p

	include	build.inc
	include	segdefs.inc
	include tss.inc
	include gdt.inc
	include idt.inc
	include pc9800.inc

;------------------------------------------------------------------------

	start_data16

	extrn	_tss_ptr:word
	extrn	_was_exception:word
	extrn	_npx:byte
	extrn	_external_int:word

	extrn	_e_tss:tss_s
	extrn	_p_tss:tss_s

;	public	_was_user_int
;_was_user_int	dw	0

	public	ivec_number
ivec_number	db	?

;has_error	db	0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,0,0

	end_data16

;------------------------------------------------------------------------

	.286c
	start_bss

	public	_gdt
_gdt	label	gdt_s
	db	type gdt_s * g_num dup (?)

	public	_idt
_idt	label	idt_s
	db	type idt_s * 256 dup (?)

	public	_i_tss
_i_tss	label	tss_s
	db	type tss_s dup (?)

	end_bss
	.386p

;------------------------------------------------------------------------

	start_code16

ivec	macro	n
;	push	ds
;	push	g_rdata
;	pop	ds
;	mov	ivec_number,n
;	pop	ds
	db	68h
	dw	n		;push	n
	db	0eah
	dw	0, g_itss
	endm

	public	_ivec0, _ivec1
_ivec0:
	ivec 0
_ivec1:
	x=1
	rept 255
	 ivec x
	 x=x+1
	endm

	public	_interrupt_common
_interrupt_common:
	cli
if	NMI_CONTROL
	out	NMI_DISABLE,al
endif
	mov	bx,g_rdata
	mov	ds,bx
	mov	bx,_tss_ptr
	mov	esi,[bx].tss_esp
	mov	fs,[bx].tss_ss		; fs:esi -> stack
	cld
	lods	word ptr fs:[esi]
;	mov	al,ivec_number
	mov	ivec_number,al
	mov	[bx].tss_irqn,al
	cmp	al,08H			; Double Fault
	jbe	not_external_int
	cmp	al,18H			;OƊO݂dȂĂ
	jae	has_no_error
	cmp	al,0FH
	je	not_external_int
	cmp	al,10H			;NPX Error
	je	not_external_int
	;
	mov	_external_int,1		;O݂
	cmp	al,09H
	jne	has_no_error		;NPX Segment Over?
	mov	al,ISR_READ
	out	MASTER_PIC,al
	delay
	in	al,MASTER_PIC
	bt	ax,1
	jc	has_no_error		;O݂ȂJUMP
	;
not_external_int:
	mov	_external_int,0		;O
;	cmp	has_error[di],0
;	je	has_no_error		;NPX Segment Over ȂJUMP
;	mov	eax,fs:[esi]
	xor	eax,eax
	mov	[bx].tss_error,eax
;	add	esi,4			;Error Codesplit
has_no_error:
;	mov	eax,fs:[esi]		; eip
	lods	dword ptr fs:[esi]
	mov	[bx].tss_eip,eax
;	mov	eax,fs:[esi+4]
	lods	dword ptr fs:[esi]
	mov	[bx].tss_cs,ax
;	mov	eax,fs:[esi+8]
	lods	dword ptr fs:[esi]
	mov	[bx].tss_eflags,eax
;	add	esi,12
	mov	[bx].tss_esp,esi	; store corrected stack pointer

	mov	_was_exception,1

	jmpt	g_ctss			; pass control back to real mode
	cli
	jmp	_interrupt_common	; it's a task

	extrn	graphics_fault:near

	public	_page_fault
_page_fault:
	cli
if	NMI_CONTROL
	out	NMI_DISABLE,al
endif
	mov	bx,g_rdata
	mov	ds,bx
	mov	es,bx
	;
	mov	bx,offset _p_tss
;	mov	[bx].tss_back_link,g_ctss
	cmp	esp,[bx].tss_esp
	jne	short _page_exception	;dR[hΗO
	mov	_external_int,1		;O݂
	xor	eax,eax
	push	eax			;_~[
	jmp	short regular_pf

_page_exception:
	mov	eax,cr2
	cmp	eax,0e0000000h
	jb	short regular_pf
	cmp	eax,0e007ffffh		;nC][huq`lGA
	ja	short regular_pf
	jmp	graphics_fault		;a`̂fuq`lANZX
	;
regular_pf:
	mov	bx,_tss_ptr
	mov	[bx].tss_irqn,14	; page fault
	mov	[bx].tss_cr2,eax
	pop	eax
	mov	[bx].tss_error,eax

	mov	eax,0
	mov	cr2,eax	; so we can tell INT 0D from page fault

	mov	_was_exception,1
	jmpt	g_ctss
;	iret
	cli
	jmp	_page_fault

	public	_except_check
_except_check:				;O݁^O
	cli
if	NMI_CONTROL
	out	NMI_DISABLE,al
endif
	mov	bx,g_rdata
	mov	ds,bx
	;
	mov	bx,_tss_ptr
	mov	di,offset _e_tss
;	mov	[di].tss_back_link,g_ctss
	str	ax
	sub	ax,g_e08tss - 64
	shr	ax,3
	mov	[bx].tss_irqn,al	;sq犄ݔԍZo
	;
	cmp	esp,[di].tss_esp
	jne	_except_check_1		;G[R[hΗO
	mov	_external_int,1		;O݂
	xor	eax,eax
	push	eax			;_~[
_except_check_1:
	pop	eax
	mov	[bx].tss_error,eax
	mov	_was_exception,1
	jmpt	g_ctss
;	iret
	cli
	jmp	_except_check

	end_code16

;------------------------------------------------------------------------

	end
