;; fepctrl.el: Kana-Kanji Translation FEP Control Library.
;;
;; Edition History:
;; 1.1 91/11/28 Manabu Higashida Creation.
;;
 
;; Copyright (C) 1991 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.

(defconst fep-name-list
  '("(none)"  ;  0
    "PC9801A" ;  1
    "PC9801B" ;  2
    "MSKANJI" ;  3
    "VJE"     ;  4
    "ATOK6"   ;  5
    "ATOK7"   ;  6
    "MTTK86"  ;  7
    "MTTK2"   ;  8
    "KATANA"  ;  9
    "FIXER"   ; 10
    "EGB2"    ; 11
    "EGB3"    ; 12
    "WXP"     ; 13
    "WX2"     ; 14
    "MGR2"    ; 15
    "JJ"      ; 16
    "NEC"     ; 17
    "DFJ"     ; 18
    "KAZE"    ; 19
    "OAK"     ; 20
    "MKK"     ; 21
    "B16"     ; 22
    "RICOH"   ; 23
    "WXPJ"    ; 24
    "MIJ"     ; 25
    "FEPEX"   ; 26
    "AT6AX"   ; 27
    "AT6IBM"  ; 28
    "AT7IBM"  ; 29
    "AT7DOSV" ; 30
    "IBMIAS"  ; 31
    ))

(defvar fep-name nil)

(or (fboundp 'si:fep-init)
    (fset 'si:fep-init (symbol-function 'fep-init)))

(defun fep-init ()
  (let ((fep-id (si:fep-init)))
    (if (or (not (numberp fep-id))
	    (zerop fep-id))
	(setq inhibit-fep-control t)
      (setq fep-name (nth fep-id fep-name-list)))))

(defun fep-sync ()
  (interactive)
  (if fep-mode
      (fep-force-on)
    (fep-force-off)))

(defun toggle-fep-mode ()
  (interactive)
  (if fep-mode
      (fep-force-off)
    (fep-force-on)))

;;;

;(or (fboundp 'si:universal-argument)
;    (fset 'si:universal-argument (symbol-function 'universal-argument)))

;(defun universal-argument ()
;  (interactive nil)
;  (fep-off)
;  (unwind-protect
;      (si:universal-argument)
;    (fep-on)))

;;;

;(or (fboundp 'si:isearch)
;    (fset 'si:isearch (symbol-function 'isearch)))

;(defun isearch (forward &optional regexp)
;  (fep-off)
;  (unwind-protect
;      (si:isearch forward regexp)
;    (fep-on)))

;(or (fboundp 'si:read-string)
;    (fset 'si:read-string (symbol-function 'read-string)))
;
;(defun read-string (args &optional arg1)
;  (fep-on)
;  (unwind-protect
;      (funcall 'si:read-string args arg1)
;    (fep-off)))

;;;

;
; This doesn't work correctly to handle C-h.
;
;(or (fboundp 'si:help-for-help)
;    (fset 'si:help-for-help (symbol-function 'help-for-help)))
;
;(defun help-for-help ()
;  (interactive)
;  (fep-off)
;  (unwind-protect
;      (si:help-for-help)
;    (fep-on)))
