/***************************************************************/
/*                                                             */
/*  E2O.C                                                      */
/*                                                             */
/*  Redirect stderr to stdout.                                 */
/*                                                             */
/*  (C) 1990 by David Skoll.                                   */
/*                                                             */
/***************************************************************/
#include <io.h>
#include <stdio.h>
#include <process.h>
#include <string.h>
#include <stdlib.h>

char buf[40];

main(int argc, char *argv[], char *env[])
{
   char *s, *s1;
   int save_err = dup(fileno(stderr));

   if (argc == 1) {
      fprintf(stderr, "Usage: E2O program [args]\n");
      exit(1);
   } 

   /* Force stderr to be stdout */
   if (dup2(fileno(stdout), fileno(stderr)) == -1 ) {
      fprintf(stderr, "Can't redirect stderr!\n");
      exit(1);
   }
   strcpy(buf, argv[1]);

   s = strrchr(buf, '.');
   s1 = strrchr(buf, '\\');
   if (s1 != NULL && s < s1) s = NULL;

   /* Try .COM first */
   if (s == NULL) strcat(buf, ".COM");
   execvpe(buf, &argv[1], env);

   /* If we got here, it didn't work... try .EXE */
   if (s == NULL) {
      strcpy(buf, argv[1]);
      strcat(buf, ".EXE");
      execvpe(buf, &argv[1], env);
   }

   /* Die here */
   dup2(save_err, fileno(stderr));
   fprintf(stderr, "Can't exec %s.\n", argv[1]);
   exit(1);
}