/****************************************************************
*
*  Name:          EXAMPLES
*
*  Function:      Display a menu listing the example programs and
*                 start an example as a new process when so requested.
*
*  Shows how to:  1. read a DESQview Program Information File (DVP)
*                    from disk. 
*                 2. adjust the DVP to reflect the current drive and 
*                    directory.
*                 3. start a new process using the DVP.
*
****************************************************************/

#include <stdio.h>
#include "dvapi.h"

/* minimum API version required and actual version */
#define required 0x201
int  version;

/* object handles */
ulong win,kbd,apphan;

/* variables used when reading the menu */
char *kbuf,field;
int   klng;

/* file variables */
FILE *f1,*fopen();

/* buffers for the DVP and for the current directory path */
char dvpbuf[416];
char pathbuf[64];

/* error messages */
char error1[] = " Can't find .DVP file ";
int  lerror1  = sizeof(error1)-1;
char error2[] = " Error loading .DVP file ";
int  lerror2  = sizeof(error2)-1;

/* DVP file names for each menu entry */
char *pif_names[] = {"hello.dvp",
                     "fruit.dvp",
                     "point.dvp",
                     "washer.dvp",
                     "snakes.dvp",
                     "server.dvp",
                     "request.dvp"};

/* menu contents */
char menu1[] = "\
                \
 Hello       HE \
 Fruit       FR \
 Point       PT \
 Washer      WA \
 Snakes      SN \
 Server      SV \
 Request     RQ ";
 

/* menu field table */
char ftab1[] = {ftab(9,FTH_KEYSELECT+FTH_MODIFIED,0,0,9,1),
                     0,8,0,8,FTE_OUTPUT,0,0,0,
                     1,0,1,15,FTE_SELECT,'H',1,'E',
                     2,0,2,15,FTE_SELECT,'F',1,'R',
                     3,0,3,15,FTE_SELECT,'P',1,'T',
                     4,0,4,15,FTE_SELECT,'W',1,'A',
                     5,0,5,15,FTE_SELECT,'S',1,'N',
                     6,0,6,15,FTE_SELECT,'S',1,'V',
                     7,0,7,15,FTE_SELECT,'R',1,'Q',
                     1,0,0,0,FTE_SELECT,27,1,0, /* Esc - invisible field */
                     };


/**********************************************************************
*  main  -  check for DESQview present and enable required extensions.
***********************************************************************/

main () {
  /* initialize C interfaces and get API version number */
  version = api_init();

  /* if DESQview is not running or version is too low, display a message */ 
  if (version < required) {
    printf ("This program requires DESQview version %d.02%d or later.\n",
             required/256,required%256);
    }

  /* tell DESQview what extensions to enable and start application */
  else {
    api_level (required);
    program_body();
    }

  /* disable C interfaces and return from program */
  api_exit();
  }


/**********************************************************************
*  program_body  -  display list of examples and start then when selected.
***********************************************************************/

program_body () {
  /* get default object handles */
  win = win_me();
  kbd = key_me();

  /* resize the physical and logical window */
  win_resize (win,8,16);
  win_lsize (win,8,16); 

  /* position the window and set to use logical attributes */
  win_origin (win,0,0);
  win_move (win,1,63);
  win_logattr (win,1);
  win_attr (win,1);

  /* turn on field mode, turn off hardware cursor */
  key_subfrom (kbd,KBF_CURSOR);
  key_addto (kbd,KBF_FIELD);

  /* write contents and field table to the menu and display it */
  win_swrite (win,menu1);
  win_stream (win,ftab1);
  win_redraw (win);

  /* loop until the window is closed */
  while (1) {

    /* wait for menu selection, determine field #, and deselect it */
    key_read (kbd,&kbuf,&klng); 
    field = *kbuf; 
    fld_reset (win); 

    /* exit if field 9 (ESC) selected */
    if (field == 9) break;

    /* open DVP file and display error message if necessary */
    f1 = fopen(pif_names[field-2],"rb");
    if (f1 == NULL) {
      win_disperor (win,error1,lerror1,1,lerror1,1,0);
      continue;
      }

    /* read DVP file and display error message if necessary */
    if (fread (dvpbuf,416,1,f1) != 1) {
      win_disperor (win,error2,lerror2,1,lerror2,1,0);
      continue;
      }

    /* close the DVP file and get current directory */
    fclose (f1);
    if (getcwd (pathbuf,64) == NULL) break;

    /* set drive letter and data path fields in the DVP */
    dvpbuf[100] = pathbuf[0];
    strcpy (&dvpbuf[101],&pathbuf[2]);

    /* start the application and loop */
    apphan = app_start(dvpbuf,416);
    }
  }
