;-----------------------------------------------------------------------;
; This file contains the support files for DIRM v1.3 (c) 1990           ;
; by Michael P. Rice.  These must be assembled and linked to the .OBJ   ;
; file produced by DIRM13.ASM.  Portions of this source code are the    ;
; copyrighted property of Michael P. Rice and are not public domain.    ;
; DIRM v1.3 cannot be used commerically without consent.                ;
;-----------------------------------------------------------------------;
.model small

.data

	public	SCREEN_PTR
	public	SCREEN_X, SCREEN_Y
SCREEN_SEG	DW	0b800h		;Segment of the screen buffer
SCREEN_PTR	DW	0		;Offset into screen memory of cursor
SCREEN_X	DB	0		;Position of the screen cursor
SCREEN_Y	DB	0


.code

	public send_crlf
;-----------------------------------------------------------------------;
; This is a C callable procedure that sends a CR and LF to the screen.	;
; Uses: UPDATE_VIRTUAL_CURSOR						;
;-----------------------------------------------------------------------;
send_crlf	PROC
	push ax
	push dx
	mov ah,2
	mov dl,13			;13 is ASCII for CR
	int 21h
	mov dl,10			;10 is ASCII for LF
	int 21h
	call update_virtual_cursor	;Update position of virtual cursor
	pop dx
	pop ax
	ret
send_crlf	ENDP

	public goto_col
;-----------------------------------------------------------------------;
; This procedure moves the screen pointer to the specified position     ;
; in AL (As I recall).                                                  ;
;-----------------------------------------------------------------------;
goto_col	PROC
	push ax
	push bx
	
	mov al,SCREEN_Y
	mov bl,80
	mul bl
	add al,dl
	adc ah,0
	shl ax,1
	mov SCREEN_PTR,ax
	mov SCREEN_X,dl

	pop bx
	pop ax
	ret
goto_col	ENDP
	public write_char
;-----------------------------------------------------------------------;
; This procedure outputs a character to the screen by writing directly	;
; into screen memory, so that characters such as the backspace are	;
; treated as any other character and are displayed.			;
;									;
; This procedure must do a bit of work to update the cursor position.	;
;									;
; On Entry:	DL	Byte to print on screen.			;
;									;
; Uses:		CURSOR_RIGHT						;
; Reads:	SCREEN_SEG, SCREEN_PTR					;
;-----------------------------------------------------------------------;
write_char proc
	push ax			;Save registers used in procedure
	push bx
	push dx
	push es

	mov ax,SCREEN_SEG	;Get segment for screen memory
	mov es,ax		;Point ES to screen memory
	mov bx,SCREEN_PTR	;Pointer to character in screen memory

	mov dh,7		;Use the normal attribute
        mov es:[bx],dx          ;Write the character/attribute to screen
	call cursor_right	;Now move to next cursor position

	pop es
	pop dx			;Restore registers to precall value
	pop bx
	pop ax
	ret
write_char endp

	public	write_string
;-----------------------------------------------------------------------;
; This procedure writes a string of characters to the screen. The	;
; string must end with	DB 	0					;
;									;
; On entry:	DS:DX	Address of the string				;
;									;
; Uses:		WRITE_CHAR						;
;-----------------------------------------------------------------------;
write_string	proc
	push ax
	push dx
	push si
	pushf				;Save direction flag
	cld				;Set direction for increment (forward)
	mov si,dx			;Place address into SI for LODSB
string_loop:
	lodsb				;Get a character into the AL register
	or al,al			;Have we found a zero yet?
	jz end_of_string		;Yes, we are done with string
	mov dl,al			;No, write character
	call write_char	
	jmp string_loop
end_of_string:
	popf				;Restore direction flag
	pop si
	pop dx
	pop ax
	ret
write_string	endp


cr	equ	13		;Carriage return
lf	equ	10		;Line feed


	public cursor_right
;-----------------------------------------------------------------------;
; This procedure moves the cursor one position to the right or to the	;
; next line if the cursor was at the end of a line.			;
;									;
; Uses:		SEND_CRLF						;
; Writes:	SCREEN_PTR, SCREEN_X, SCREEN_Y				;
;-----------------------------------------------------------------------;
cursor_right    proc
	inc SCREEN_PTR			;Move to next cursor position (word)
	inc SCREEN_PTR
	inc SCREEN_X			;Move to next column
	cmp SCREEN_X,79			;Make sure column <= 79
	jbe ok
	call send_crlf			;Go to next line
ok:
	ret
cursor_right	endp


	public write_decimal
;-----------------------------------------------------------------------;
; This procedure writes a 16-bit, unsigned number in decimal notation.	;
;									;
; On Entry:	DX	N : 16-bit, unsigned number.			;
;									;
; Uses:		WRITE_HEX_DIGIT						;
;-----------------------------------------------------------------------;
write_decimal proc
	push ax			;Save registers used here
	push cx
	push dx	
	push si
	mov ax,dx	
	mov si,10		;Will divide by 10 using SI
	xor cx,cx		;count of digits placed on stack
non_zero:
	xor dx,dx		;Set upper word of N to 0
	div si			;Calculate N/10 and (N mode 10)
	push dx			;Push one more digit onto stack
	inc cx			;One more digit added
	or ax,ax		;N = 0 yet?
	jne non_zero		;Nope, continue
write_digit_loop:
	pop dx			;Get the digits in reverse order
	call write_hex_digit	
	loop write_digit_loop
end_decimal:
	pop si			;Restore regsiters
	pop dx
	pop cx
	pop ax
	ret
write_decimal	endp

	public write_hex_digit
;-----------------------------------------------------------------------;
; This procedure converts the lower 4 bits of DL to a hex digit and	;
; writes it to the screen.						;
; 									;
; On Entry:	DL	Lower 4 bits contain number to be printed	;
;			in hex.						;
;									;
; Uses:		WRITE_CHAR						;
;-----------------------------------------------------------------------;
write_hex_digit proc
	push dx			;Save registers used
	cmp dl,10		;Is this nibble <10?
	jae hex_letter		;No? Convert to a letter!
	add dl,"0"		;Yes? Convert to a digit!
	jmp Short write_digit	;Now write this character
hex_letter:
	add dl,"A"-10		;Convert to hex letter
write_digit:
	call write_char		;Display the letter on the screen
	pop dx			;Restore register
	ret			
write_hex_digit endp

	public 	update_virtual_cursor
;-----------------------------------------------------------------------;
; this procedure updates the position of our virtual cursor to agree	;
; with the position of the real cursor.					;
;-----------------------------------------------------------------------;
update_virtual_cursor   proc
	push ax
	push bx
	push cx
	push dx
	mov ah,3			;Ask for cursor position
	xor bh,bh			;On page 0
	int 10h				;get cursor position into DH, DL
        call goto_xy                    ;Move virtual cursor to this position
	pop dx
	pop cx
	pop bx
	pop ax
	ret
update_virtual_cursor	ENDP

	public	goto_xy
;-----------------------------------------------------------------------;
; This procedure move the cursor					;
;									;
; On entry:	DH	Row (Y)						;
;		DL	Column (X)					;
;-----------------------------------------------------------------------;
goto_xy	proc
	push ax
	push bx
	mov bh,0			;Display page 0
	mov ah,2			;Call for SET CURSOR POSITION
	int 10h

	mov al,dh			;Get the row number
	mov bl,80			;Multiply by 80 chars per line
	mul bl				;AX = row * 80
	add al,dl			;Add column
	adc ah,0			;AX = row * 80 + column
	shl ax,1			;Convert to a byte offset
	mov SCREEN_PTR,ax		;Save the cursor offset
	mov SCREEN_X,dl			;Save the cursor position
	mov SCREEN_Y,dh

	pop bx
	pop ax
	ret
goto_xy	ENDP

        public  init_write_char
;-----------------------------------------------------------------------;
; You need to call this procedure before you call WRITE_CHAR since	;
; WRITE_CHAR uses information set by this procedure.			;
;-----------------------------------------------------------------------;
init_write_char         proc
	push ax
	push bx
	mov bx,0b800h			;Set for color graphics display
	int 11h				;Get equipment information
	and al,30h			;Keep just the video display type
	cmp al,30h			;Is this monochrome adapter?
	jne set_base			;No, it's color
	mov bx,0b000h			;Yes, it's monochrome, use B000
set_base:
	mov screen_seg,bx		;Save the screen segment
	call update_virtual_cursor	;Set our virtual cursor
	pop bx
	pop ax
	ret
init_write_char	endp


	public clear_to_end_of_line
;-----------------------------------------------------------------------;
; This procedure clears the line from the current cursor position to  	;
; the end of that line.							;
;-----------------------------------------------------------------------;
clear_to_end_of_line	proc
	push ax
	push bx
	push cx
	push dx
        mov dl,SCREEN_X
        mov dh,SCREEN_Y
        mov ah,6                        ;Set up to clear to end of line
	xor al,al			;Clear window
	mov ch,dh			;All on same line
	mov cl,dl			;Start at the cursor position
	mov dl,79			;And stop at the end of the line
	mov bh,7			;Use normal attribute
	int 10h
	pop dx
	pop cx
	pop bx
	pop ax
	ret
clear_to_end_of_line	endp

	end
