;v1.1 Rewrite of a utility found on SIMTEL20.
;Original was obviously written in C, and was full of
;horribly inefficient code and unused functions produced
;by a thoroughly braindead C compiler.

;This version, while equally trivial, is at least efficient.
;
;Released to the public domain.
;David Kirschbaum
;Toad Hall
;kirsch@sesi.com


CR	equ	0dh
LF	equ	0ah
SPACE	equ	32
TAB	equ	9

CSEG	SEGMENT PUBLIC PARA 'CODE'
	ASSUME	CS:CSEG,DS:CSEG,ES:CSEG

	ORG	100H

SameDate	PROC	NEAR
	jmp	Start				;skip over data

logo	db	'SAMEDATE -- $'		;we use this a lot

logo1	db	'V1.1 Public Domain Utility',CR,LF
	db	'David Kirschbaum, Toad Hall',CR,LF,'$'

msg1	db	'successful completion$'

msg2	db 'call error, calling sequence is:',CR,LF,CR,LF
	db '       SAMEDATE file1 file2',CR,LF,CR,LF
	db 'Action is to give file2 the same date as file1',CR,LF
	db '   plus 1 minute.',CR,LF,'$'

msg3	db 'unable to open first file',CR,LF,'$'
msg4	db 'unable to open second file',CR,LF,'$'
msg5	db 'unable to read date from first file',CR,LF,'$'
msg6	db 'unable to set date for second file',CR,LF,'$'

cmd_ptr	dw	81h			;address of first byte of command tail
ftime	dw	0			;first file's time
fdate	dw	0			;first file's date

Start:	mov	dx,offset logo1		;logo
	call	WriteMsg		;display

;Do something horrible, just to scandalize the readers.

	mov	ax,offset Msg_Term	;where we'll always end
	push	ax

	call	Get_Arg			;get first cmdline parm
	jnc	Got_1			;got one

CmdErr:	mov	dx,offset msg2		;'Call error..'
	mov	al,0BH			;invalid format error
	ret				;display, terminate

Got_1:	mov	ax,3D00H		;open file, read-only
	int	21H			;DX -> AsciiZ filename
	jb	OpenFail_1		;failed, msg, die

	mov	bx,ax			;handle into BX
	mov	ax,5700h		;get file date/time
	int	21h
	jb	DateFail_1		;failed, msg, die

	mov	ftime,cx		;save file time
	mov	fdate,dx		;and file date

	mov	ah,3EH			;close file
	int	21h

	call	Get_Arg			;get second cmdline parm
	jb	CmdErr			;no got:  error msg, die

	mov	ax,3D02H		;open file, read/write
	int	21H			;DX -> AsciiZ filename
	jb	OpenFail_2		;failed, msg, die

	mov	bx,ax			;handle into BX
	mov	cx,ftime		;first file's time
	add	cx,1Eh			;add one second
	mov	dx,fdate		;first file's date
	mov	ax,5701h		;set file date/time
	int	21h
	jb	DateFail_2		;failed, msg, die

	mov	ah,3EH			;close file
	int	21h			;(handle still in BX)

	mov	dx,offset msg1		;'Successful completion'

;Common way to display msg and terminate
Msg_Term:
	push	ax			;save ERRORLEVEL in AL
	call	WriteMsg		;display string in DX
	pop	ax			;restore

	mov	ah,4CH			;terminate
	int	21H


OpenFail_1:
	mov	dx,offset msg3		;'Unable to open first file
	ret				;to Msg_Term

OpenFail_2:
	mov	dx,offset msg4		;'Unable to open second file'
	ret

;Unable to read first file's date
DateFail_1:
	mov	dx,offset msg5		;'Unable to read date from 1st file
	ret

;Failed to set second file's date
DateFail_2:
	mov	dx,offset msg6		;'Unable to set date for second file'
	ret

SameDate	ENDP


WriteMsg	PROC	NEAR

	push	dx			;save msg
	mov	dx,offset logo		;'SAMEDATE -- '
	mov	ah,9			;display msg
	int	21H
	pop	dx			;restore original msg
	mov	ah,9			;display msg
	int	21H
	ret
WriteMsg	ENDP


;* Get_Arg - Returns the address of the next command line argument in DX.
;* The argument is in the form of an ASCIIZ string.
;* Returns Carry = 1 if no more command line arguments.
;* Upon exit, if Carry is set, the contents of DX is undefined.

Get_Arg	PROC	NEAR
	mov	si,cmd_ptr		;last cmdline position
skip_space:				;scan over leading spaces and commas
	lodsb
	or	al,al			;if we get a null
	jz	sk0
	cmp	al,CR			;or a CR,
	jnz	sk1
sk0:	stc				;set carry to indicate failure
	ret				;and exit

sk1:	cmp	al,SPACE
	jz	skip_space		;loop until no more spaces
	cmp	al,','
	jz	skip_space		;or commas
	cmp	al,TAB
	jz	skip_space		;or tabs

	mov	dx,si			;start of argument
	dec	dx
Get_Arg1:
	lodsb				;get next character
	cmp	al,CR			;argument seperators are CR,
	jz	Get_Arg2
	cmp	al,SPACE		;space,
	jz	Get_Arg2
	cmp	al,','			;comma,
	jz	Get_Arg2
	cmp	al,TAB			;and tab
	jnz	Get_Arg1

Get_Arg2:
	mov	byte ptr [si-1],0	;delimit argument with 0
	cmp	al,CR			;if char is CR then we've reached
	jnz	ga2			; the end of the argument list
	 dec	si
ga2:	mov	cmd_ptr,si		;save for next time 'round
	ret				;and return
Get_Arg	ENDP


CSEG	ENDS
	END	SameDate
