/*
 * written by Bob Sloane, Lawrence, KS.
 * This program is released into the public domain.
 */

#include <stdio.h>

#define HIDDEN 0x2B68
#define SYSTEM 0x2B73
#define PERCNT 0x2B70
#define DEPTH  0x643D
#define MATCH  0x6D3D
#define FORM1  0x2222
#define FORM2  0x2727
#define BEFORE 0x623D
#define AFTER  0x613D

int  atbyte = {0};          /* default attribute is all normal files */
int  depth  = {1};          /* default depth is one level */
unsigned bdate = {0xFFFF};  /* default before date is infinity */
unsigned adate = {0};       /* default after date is null */
unsigned btime = {0xFFFF};  /* default before time is after midnight */
unsigned atime = {0};       /* default after time is early in the morning */
char match[128] = {"*.*"};  /* default is all files */
char format[128] = {"%p\n"};/* default is to print pathname only */
char path[128] = {""};      /* default to current drive, current dir */
char volume[12];            /* disk volume name, if any */
int  percent = {0};         /* default is don't do percent files */
int  found = {0};           /* flag set to one if file found */
extern char *_psp;          /* segment value of program prefix */

main()
{
    char *argp,*argend,argbuf[128];   /* pointer to command line char */
    char ch1,ch2;                     /* hold 1st and 2nd argument chars */
    int  i;                           /* counter for loops */
    int  drive;                       /* drive number for drive given */
    char del1,del2;                   /* delimiters for date/time */
    unsigned v1,v2,v3;                /* values for date/time */
    char *skipnm();                   /* function to skip over numeric arg */
    
    peek(_psp,0x80,&ch1,1);           /* get number of chars in cmd line.*/
    peek(_psp,0x81,argbuf,ch1);       /* get the command line */
    argp = &argbuf[0];                /* address of 1st char */
    argend = &argbuf[ch1];            /* address of end of command line */
    *argend = EOS;                    /* make the command line a string */
    
    while ( argp < argend ) {         /* while not at end of line */

	while (*argp == ' ') ++argp;  /* skip blanks between args */
	if ( *argp == EOS ) break;    /* no more args */

	ch1 = tolower(*argp++);       /* get first arg character */
	if ( ch1 != '"' && ch1 != '\'' ) /* if not quoted arg */
	    ch2 = tolower(*argp++);   /* get next character */
	else
	    ch2 = ch1;                /* indicate quoted string */
	
	switch ( ch1<<8 | ch2 ) {     /* process arg by type */
	    case HIDDEN:
		atbyte |= 2;          /* set to show hidden files */
		break;
	    case SYSTEM:
		atbyte |= 4;          /* set to show system files */
		break;
	    case PERCNT:
		percent = 1;          /* set to show percent files */
		break;
	    case DEPTH:
		depth = atoi(argp);   /* get integer depth */
		argp = skipnm(argp);  /* skip over string of digits */
		break;
	    case MATCH:               /* process match= arg */
		for ( i=0; *argp != EOS && *argp != ' '; ++i )
		    match[i] = *argp++;  /* copy to global variable */
		match[i] = EOS;       /* finish off string */
		break;
	    case BEFORE:
		v1 = atoi(argp);      /* get first 1 or 2 digits */
		argp = skipnm(argp);  /* skip over them */
		del1 = *argp;         /* get the 1st delimiter */
		if ( del1 == ':' || del1 == '/' ) {  /* ok so far */
		    v2 = atoi(++argp);    /* get second field */
		    argp = skipnm(argp);  /* skip over it */
		    del2 = *argp;         /* get second delimiter */
		    if ( del1 == del2 ) { /* if there is another field */
			v3 = atoi(++argp);/* get last field */
			argp = skipnm(argp);
		    }
		    else if ( del1==':' && (del2==' ' || del2==EOS)) {
			v3 = 0;           /* make third field null for time */
			del2 = ':';       /* pretend we got the right delim */
		    }
		}
		else
		    del2 = del1+1;        /* force an error on next if */
		if ( del1 != del2 ) {
		    fprintf(stderr,"Invalid date or time parameter\n");
		    exit(1);
		}
		if ( del1 == '/' ) {      /* are we doing a date? */
		    if ( v3 > 1900 ) v3 -= 1900;
		    bdate = (((v3-80)&0177)<<9) | ((v1&017)<<5) | (v2&037);
		}
		else
		    btime = ((v1&037)<<11) | ((v2&077)<<5) | ((v3>>1)&037);
		break;
		
	    case AFTER:
		v1 = atoi(argp);      /* get first 1 0r 2 digits */
		argp = skipnm(argp);  /* skip over them */
		del1 = *argp;         /* get the 1st delimiter */
		if ( del1 == ':' || del1 == '/' ) {  /* ok so far */
		    v2 = atoi(++argp);    /* get second field */
		    argp = skipnm(argp);  /* skip over it */
		    del2 = *argp;         /* get second delimiter */
		    if ( del1 == del2 ) { /* if there is another field */
			v3 = atoi(++argp);/* get last field */
			argp = skipnm(argp);
		    }
		    else if ( del1==':' && (del2==' ' || del2==EOS)) {
			v3 = 0;           /* make third field null for time */
			del2 = ':';       /* pretend we got the right delim */
		    }
		}
		else
		    del2 = del1+1;        /* force an error on next if */
		if ( del1 != del2 ) {
		    fprintf(stderr,"Invalid date or time parameter\n");
		    exit(1);
		}
		if ( del1 == '/' ) {      /* are we doing a date? */
		    if ( v3 > 1900 ) v3 -= 1900;
		    adate = (((v3-80)&0177)<<9) | ((v1&017)<<5) | (v2&037);
		}
		else
		    atime = ((v1&037)<<11) | ((v2&077)<<5) | ((v3>>1)&037);
		break;
		
	    case FORM1: case FORM2:
		for ( i=0; *argp != EOS; ++i ) {
		    format[i] = *argp++; /* copy the character */
		    if ( format[i] == ch1 && (*argp == EOS || *argp == ' ') )
			break;
		    if ( format[i] == ch1 && *argp == ch1 ) /* process "" */
			++argp;          /* skip second quote */
		}
		format[i++] = '\n';      /* each file on a new line */
		format[i] = EOS;         /* finish off the string */
		break;
	    default:                     /* assume this is a path string */
		argp -= 2;               /* back up to start of path */
		for ( i=0; *argp != EOS && *argp != ' '; ++i)
		    path[i] = *argp++;   /* copy path to local storage */
		if ( path[i-1] != '\\' && path[i-1] !=':' )
		    path[i++] = '\\';    /* append backslash to path */
		path[i] = EOS;           /* finish off path string */
	}
    }

    if ( path[1] == ':' )     /* if drive was given */
	drive = path[0]&0x1f; /* get drive number */
    else
	drive = 0;            /* else use default drive */
    getvol(volume,drive);     /* get disk volume name */
    
    walk(path, 1);            /* go walk the highest level */
    if ( !found )
	fprintf(stderr,"No match found for %s%s\n",path,match);
}

walk(path, d)
    char *path;
    int  d;
{
    char current[128],subdir[128];
    REGS regsin, regsout;
    struct {
        char attrib[22];
	unsigned ftime;
        unsigned fdate;
        long filesz;
        char name[13];
        char fill[128-43];
    } fildes;
    unsigned long fmod,amod,bmod;

    bdos(0x1A, &fildes);                       /* set DTA to local store */
    strcpy(current,path);                      /* get current path string */
    strcat(current,match);                     /* make the search pattern */
    regsin.dx = (int) &current[0];             /* set args for dos call */
    regsin.cx = atbyte;
    for (regsin.ax=0x4E00;(intdos(&regsin,&regsout)&1)==0; regsin.ax=0x4F00) {
	fmod = (unsigned long)(((unsigned long)fildes.fdate<<16) | fildes.ftime);
	bmod = (unsigned long)(((unsigned long)bdate<<16) | btime);
	amod = (unsigned long)(((unsigned long)adate<<16) | atime);
	if ( (fildes.name[0]!='%' || percent) &&
	     (amod<=fmod && fmod<bmod) ) {
		print(path,fildes);            /* print the user's line */
		found = 1;                     /* show we did one file */
	}
    }

    if ( d >= depth )                          /* more levels is needed */
	return;                                /* no - exit now */

    strcpy(current,path);                      /* get current path string */
    strcat(current,"*.*");                     /* make the search pattern */
    regsin.dx = (int) &current[0];             /* set args for dos call */
    regsin.cx = 0x10;                          /* set the atrib to subdir */
    for (regsin.ax=0x4E00;(intdos(&regsin,&regsout)&1)==0; regsin.ax=0x4F00) {
	if ( fildes.attrib[21]& 0x10 ) {       /* is this a sub directory? */
	    if ( fildes.name[0] != '.' ) {     /* if not . or .. */
	    	strcpy(subdir,path);           /* build new path string */
	    	strcat(subdir,fildes.name);    /* add new subdirectory */
	    	strcat(subdir,"\\");           /* to end of current path */
	    	walk(subdir, d+1);
	    	bdos(0x1A, &fildes);           /* set DTA to local store */
	    }
	}
    }
}

getvol(vol, drive)
    char *vol;
    int drive;
{
    char fcb[50];
    char dta[128];
    int sts;
    
    bdos(0x1a,dta);                   /* set DTA to local store */
    
    fcb[0] = 0xff;                    /* set extended fcb */
    fcb[6] = 8;                       /* set volume name search attrib */
    fcb[7] = drive;                   /* set drive number */
    strcpy(fcb+8,"????????????");     /* set search pattern */
    sts = bdos(0x11,fcb);             /* go get volume name */
    if ( sts )                        /* if not found */
	vol[0] = '\0';                /* make volume null */
    else
	strncpy(vol,dta+8,11);        /* copy volume name to arg */
    vol += 10;
    while ( *vol == ' ' ) *vol-- = '\0';  /* trim trailing blanks */
    return sts;
}

print(path,fildes)
    char *path;
    struct {
        char attrib[22];
	unsigned ftime;
	unsigned fdate;
        long filesz;
        char name[13];
        char fill[128-43];
    } fildes;
{
    int i,len;
    char date[12],time[12],size[12],form[12],nform[12];
    char mypath[128];
    char *fmt,*skipnm();
    
    sprintf(date,"%02d/%02d/%02d",(fildes.fdate>>5)&017,(fildes.fdate&037),
                                  (fildes.fdate>>9)+80);
    sprintf(time,"%02d:%02d:%02d",fildes.ftime>>11,(fildes.ftime>>5)&077,
                                  (fildes.ftime&037)*2);
    sprintf(size,"%ld",fildes.filesz);
    strcpy(mypath,path);
    strcat(mypath,fildes.name);
    
    for ( fmt=&format[0]; *fmt != EOS; ++fmt )
	if ( *fmt == '%' ) {
	    len = atoi(++fmt);
	    fmt = skipnm(fmt);
	    sprintf(form,"%%%ds",len);
	    sprintf(nform,"%%%ds",-len);
	    switch (tolower(*fmt)) {
		case 'p': printf(nform,mypath); break;
		case 'f': printf(nform,fildes.name); break;
		case 'v': printf(nform,volume); break;
		case 'd': printf(nform,date); break;
		case 't': printf(nform,time); break;
		case 's': printf(form,size); break;
		default : putchar(*fmt);
	    }
	}
	else
	    putchar(*fmt);
}

char *skipnm(str)
    char *str;
{
    while (*str == ' ' || *str == '\t') ++str;
    if ( *str == '+' || *str == '-' ) ++str;
    while (isdigit(*str)) ++str;
    return str;
}
