Procedure Results(Var Elasped:Real;Var Seeks:Integer);
{
   This procedure prints the average seek access time of specified hard disk

   Input        Elapsed  Real elasped seconds past midnight

                Seeks    Seeks performed by the test

   Strategy     (1)      Fix Elapsed in case clock overflowed at midnight

                (2)      Calculate SeekTime in milliseconds

                (3)      Print results

}
Var
   Digits:Integer;
   SeekTime:Real;
Begin
     If Elapsed<0 then Elapsed:=86400.+Elapsed;

     SeekTime:=1000.*Elapsed/Seeks;

     Writeln;
     Write(' ...performed ');
     NormVideo;
     Write(Seeks);
     LowVideo;
     Write(' seeks in ');
     NormVideo;
     Write(Elapsed:4:0);
     LowVideo;
     Writeln(' seconds');
     Writeln;

     Writeln('  Average Access (Milliseconds)');
     Writeln;

     NormVideo;
     Write('    << Your >>');
     LowVideo;
     Write(' disk --> ');
     NormVideo;
     Writeln(SeekTime:5:1);

     LowVideo;
     Writeln;

     Writeln('    IBM-PC/XT  disk -->  93.3  (November 1985 Byte)');
     Writeln('    IBM-PC/AT  disk -->  73.3  (November 1985 Byte)');
     Writeln('    IBM-PC/AT  disk -->  38.0  (measured)');

End;
